<?php 
//===========================================================================
//* --    ~~                CRAFTY SYNTAX Live Help                ~~    -- *
//===========================================================================
//           URL:   http://www.lupopedia.com/    EMAIL: lupopedia@gmail.com
//         Copyright (C) 2003-2023 Eric Gerdes   (http://www.lupopedia.com/)
// --------------------------------------------------------------------------
 
// --------------------------------------------------------------------------
// NOTICE: Do NOT remove the copyright and/or license information any files. 
//         doing so will automatically terminate your rights to use program.
//         If you change the program you MUST clause your changes and note
//         that the original program is CRAFTY SYNTAX Live help or you will 
//         also be terminating your rights to use program and any segment 
//         of it.        
// --------------------------------------------------------------------------
// LICENSE:
//     This program is free software; you can redistribute it and/or
//     modify it under the terms of the GNU General Public License
//     as published by the Free Software Foundation; 
//     This program is distributed in the hope that it will be useful,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//     GNU General Public License for more details.
//
//     You should have received a copy of the GNU General Public License
//     along with this program in a file named LICENSE.txt .
// --------------------------------------------------------------------------  
// for updates to this code for each release look for the comment :
// <!-- upon new release: _________________  --> and do the blank.. 
require_once 'functions.php';
require_once 'security.php';
require_once 'config.php';
require_once 'config_cslh.php';


// quick and easy for anyone ungrading from 3.7.x -> 3.7.5
if($installed == true){
 
  //database connections for MYSQL set from config.php
  $conn = mysqli_connect($$server,$datausername, $password,$database );	
 
  if(!$conn) {
     $errors .= "<li>Connection to the database failed. You may have the wrong database username/password "; 
  } 

  if( ($CSLH_Config['version'] == "3.7.0") || ($CSLH_Config['version'] == "3.7.1") || ($CSLH_Config['version'] == "3.7.2")  || ($CSLH_Config['version'] == "3.7.3") || ($CSLH_Config['version'] == "3.7.4") || ($CSLH_Config['version'] == "3.7.5") ){
    $sql = "UPDATE livehelp_config set version='3.7.5' ";
    $results = $conn->query($sql);  
    $results = $conn->query($sql); 
  }
  print "DELETE THE setup.php FILE . version upgraded to 3.7.5";
  exit;
}


// ALL THAT IS BELOW IS FOR ALL THE OLD INSTALLATION AND UPGRADING OR NEW INSTALLATIONS 
//-------------------------------------------------------------------------------------
$errors ="";
$installationtype = "";
$skipwrite = false;
if(empty($UNTRUSTED['txtpath'])) $UNTRUSTED['txtpath'] = "";
if(!(empty($UNTRUSTED['installationtype'])))
  $installationtype = $UNTRUSTED['installationtype'];
else {
  $installationtype = "";
  $UNTRUSTED['installationtype']  = "";
}
          
if(!(isset($UNTRUSTED['manualinstall']))){ $UNTRUSTED['manualinstall']=""; }
if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
  $UNTRUSTED['manualinstall']="YES";
  
// The version that this setup.php installs:
// <!-- upon new release: increase the version number below. -->
$version = "3.7.5";

if(empty($UNTRUSTED['action'])){ $UNTRUSTED['action']  = ""; }

// first check to see if CSLH is already installed:
if ($installed == true){     
	  // check version installed.
	  if($version == $CSLH_Config['version']){
	  	 // already installed ask to delete setup.php:
       print "<br><br><font color=990000>Please delete file named:<b>setup.php</b></font><br> File is only used for installation and the installation program has already been run. <br><br>";
       print "<a href=config_cslh.php?removesetup=1>Click here to have server try to remove file.</a> (This may fail if server does not run as user. If so, delete it manually and then re-visit index.php file)";
       print "<br><br>";
       print "<br>After removing file <a href=index.php>click here</a>";
       exit;	
    } else {
       $UNTRUSTED['action'] = "INSTALL";
        // set upgrade installationtype
        if($CSLH_Config['version'] == "2.2"){ $installationtype = "upgrade22"; }
         if($CSLH_Config['version'] == "2.3"){ $installationtype = "upgrade22"; }
         if($CSLH_Config['version'] == "2.4"){ $installationtype = "upgrade24"; }
         if($CSLH_Config['version'] == "2.5"){ $installationtype = "upgrade25"; }
         if($CSLH_Config['version'] == "2.6"){ $installationtype = "upgrade26"; }
         if($CSLH_Config['version'] == "2.7"){ $installationtype = "upgrade27"; }
         if($CSLH_Config['version'] == "2.7.1"){ $installationtype = "upgrade271"; }
         if($CSLH_Config['version'] == "2.7.2"){ $installationtype = "upgrade272"; }
         if($CSLH_Config['version'] == "2.7.3"){ $installationtype = "upgrade273"; }
         if($CSLH_Config['version'] == "2.7.4"){ $installationtype = "upgrade274"; }    
         if($CSLH_Config['version'] == "2.8.0"){ $installationtype = "upgrade280"; }    
         if($CSLH_Config['version'] == "2.8.1"){ $installationtype = "upgrade281"; } 
         if($CSLH_Config['version'] == "2.8.2"){ $installationtype = "upgrade282"; }     
         if($CSLH_Config['version'] == "2.8.3"){ $installationtype = "upgrade283"; }  
         if($CSLH_Config['version'] == "2.8.4"){ $installationtype = "upgrade284"; }     
         if($CSLH_Config['version'] == "2.9.0"){ $installationtype = "upgrade290"; }     
         if($CSLH_Config['version'] == "2.9.1"){ $installationtype = "upgrade291"; }  
         if($CSLH_Config['version'] == "2.9.2"){ $installationtype = "upgrade292"; }  
         if($CSLH_Config['version'] == "2.9.3"){ $installationtype = "upgrade293"; }  
         if($CSLH_Config['version'] == "2.9.4"){ $installationtype = "upgrade294"; }  
         if($CSLH_Config['version'] == "2.9.5"){ $installationtype = "upgrade295"; }  
         if($CSLH_Config['version'] == "2.9.6"){ $installationtype = "upgrade296"; }  
         if($CSLH_Config['version'] == "2.9.7"){ $installationtype = "upgrade297"; }      
         if($CSLH_Config['version'] == "2.9.8"){ $installationtype = "upgrade298"; }  
         if($CSLH_Config['version'] == "2.9.9"){ $installationtype = "upgrade299"; }  
         if($CSLH_Config['version'] == "2.10.0"){ $installationtype = "upgrade2100"; }  
         if($CSLH_Config['version'] == "2.10.1"){ $installationtype = "upgrade2101"; }  
         if($CSLH_Config['version'] == "2.10.2"){ $installationtype = "upgrade2102"; }  
         if($CSLH_Config['version'] == "2.10.3"){ $installationtype = "upgrade2103"; }  
         if($CSLH_Config['version'] == "2.10.4"){ $installationtype = "upgrade2104"; } 
         if($CSLH_Config['version'] == "2.10.5"){ $installationtype = "upgrade2105"; }
         if($CSLH_Config['version'] == "2.11.0"){ $installationtype = "upgrade2110"; }
         if($CSLH_Config['version'] == "2.11.1"){ $installationtype = "upgrade2111"; }
         if($CSLH_Config['version'] == "2.11.2"){ $installationtype = "upgrade2112"; }
         if($CSLH_Config['version'] == "2.11.3"){ $installationtype = "upgrade2113"; }
         if($CSLH_Config['version'] == "2.11.4"){ $installationtype = "upgrade2114"; }
         if($CSLH_Config['version'] == "2.11.5"){ $installationtype = "upgrade2115"; }
         if($CSLH_Config['version'] == "2.11.6"){ $installationtype = "upgrade2116"; }
         if($CSLH_Config['version'] == "2.11.7"){ $installationtype = "upgrade2117"; }
         if($CSLH_Config['version'] == "2.12.0"){ $installationtype = "upgrade2120"; }    
         if($CSLH_Config['version'] == "2.12.1"){ $installationtype = "upgrade2121"; }      
         if($CSLH_Config['version'] == "2.12.2"){ $installationtype = "upgrade2122"; }  
         if($CSLH_Config['version'] == "2.12.3"){ $installationtype = "upgrade2123"; } 
         if($CSLH_Config['version'] == "2.12.4"){ $installationtype = "upgrade2124"; } 
         if($CSLH_Config['version'] == "2.12.5"){ $installationtype = "upgrade2125"; }
         if($CSLH_Config['version'] == "2.12.6"){ $installationtype = "upgrade2126"; }
         if($CSLH_Config['version'] == "2.12.7"){ $installationtype = "upgrade2127"; }
         if($CSLH_Config['version'] == "2.12.8"){ $installationtype = "upgrade2128"; }
         if($CSLH_Config['version'] == "2.12.9"){ $installationtype = "upgrade2129"; } 
         if($CSLH_Config['version'] == "2.13.0"){ $installationtype = "upgrade2130"; }                  
         if($CSLH_Config['version'] == "2.13.1"){ $installationtype = "upgrade2131"; }  
         if($CSLH_Config['version'] == "2.14.0"){ $installationtype = "upgrade2140"; } 
         if($CSLH_Config['version'] == "2.14.1"){ $installationtype = "upgrade2141"; } 
         if($CSLH_Config['version'] == "2.14.2"){ $installationtype = "upgrade2142"; } 
         if($CSLH_Config['version'] == "2.14.3"){ $installationtype = "upgrade2143"; } 
         if($CSLH_Config['version'] == "2.14.4"){ $installationtype = "upgrade2144"; } 
         if($CSLH_Config['version'] == "2.14.5"){ $installationtype = "upgrade2145"; } 
         if($CSLH_Config['version'] == "2.14.6"){ $installationtype = "upgrade2146"; } 
         if($CSLH_Config['version'] == "2.15.0"){ $installationtype = "upgrade2150"; } 
         if($CSLH_Config['version'] == "2.16.0"){ $installationtype = "upgrade2160"; } 
         if($CSLH_Config['version'] == "2.16.1"){ $installationtype = "upgrade2161"; } 
         if($CSLH_Config['version'] == "2.16.2"){ $installationtype = "upgrade2162"; } 
         if($CSLH_Config['version'] == "2.16.3"){ $installationtype = "upgrade2163"; } 
         if($CSLH_Config['version'] == "2.16.4"){ $installationtype = "upgrade2164"; } 
         if($CSLH_Config['version'] == "2.16.5"){ $installationtype = "upgrade2165"; }
         if($CSLH_Config['version'] == "2.16.6"){ $installationtype = "upgrade2166"; }          
         if($CSLH_Config['version'] == "2.16.7"){ $installationtype = "upgrade2167"; }       
         if($CSLH_Config['version'] == "2.16.8"){ $installationtype = "upgrade2168"; }    
         if($CSLH_Config['version'] == "2.16.9"){ $installationtype = "upgrade2169"; }  
         if($CSLH_Config['version'] == "3.0.0"){ $installationtype = "upgrade300"; } 
         if($CSLH_Config['version'] == "3.0.1"){ $installationtype = "upgrade301"; }                                                              
         if($CSLH_Config['version'] == "3.0.2"){ $installationtype = "upgrade302"; }    
         if($CSLH_Config['version'] == "3.0.3"){ $installationtype = "upgrade303"; }    
         if($CSLH_Config['version'] == "3.0.4"){ $installationtype = "upgrade304"; }    
         if($CSLH_Config['version'] == "3.0.5"){ $installationtype = "upgrade305"; }    
         if($CSLH_Config['version'] == "3.0.6"){ $installationtype = "upgrade306"; } 
         if($CSLH_Config['version'] == "3.0.7"){ $installationtype = "upgrade307"; } 
         if($CSLH_Config['version'] == "3.0.8"){ $installationtype = "upgrade308"; } 
         if($CSLH_Config['version'] == "3.0.9"){ $installationtype = "upgrade309"; } 
         if($CSLH_Config['version'] == "3.1.0"){ $installationtype = "upgrade310"; }                                        
         if($CSLH_Config['version'] == "3.1.1"){ $installationtype = "upgrade311"; }   
         if($CSLH_Config['version'] == "3.1.2"){ $installationtype = "upgrade312"; }   
         if($CSLH_Config['version'] == "3.1.3"){ $installationtype = "upgrade313"; }  
         if($CSLH_Config['version'] == "3.1.4"){ $installationtype = "upgrade314"; }            
         if($CSLH_Config['version'] == "3.1.5"){ $installationtype = "upgrade315"; }          
         if($CSLH_Config['version'] == "3.1.6"){ $installationtype = "upgrade316"; }     
         if($CSLH_Config['version'] == "3.1.7"){ $installationtype = "upgrade317"; }     
         if($CSLH_Config['version'] == "3.1.8"){ $installationtype = "upgrade318"; }     
         if($CSLH_Config['version'] == "3.1.9"){ $installationtype = "upgrade319"; }   
         if($CSLH_Config['version'] == "3.1.10"){ $installationtype = "upgrade3110"; }   
         if($CSLH_Config['version'] == "3.1.11"){ $installationtype = "upgrade3111"; }   
         if($CSLH_Config['version'] == "3.2.0"){ $installationtype = "upgrade320"; }   
         if($CSLH_Config['version'] == "3.2.1"){ $installationtype = "upgrade321"; }   
         if($CSLH_Config['version'] == "3.2.2"){ $installationtype = "upgrade322"; }                                                 
         if($CSLH_Config['version'] == "3.2.3"){ $installationtype = "upgrade323"; }  
         if($CSLH_Config['version'] == "3.2.4"){ $installationtype = "upgrade324"; } 
         if($CSLH_Config['version'] == "3.2.5"){ $installationtype = "upgrade325"; } 
         if($CSLH_Config['version'] == "3.2.6"){ $installationtype = "upgrade326"; } 
         if($CSLH_Config['version'] == "3.2.7"){ $installationtype = "upgrade327"; } 
         if($CSLH_Config['version'] == "3.2.8"){ $installationtype = "upgrade328"; }                            
         if($CSLH_Config['version'] == "3.3.0"){ $installationtype = "upgrade330"; }      
         if($CSLH_Config['version'] == "3.3.1"){ $installationtype = "upgrade331"; }                                                   
         if($CSLH_Config['version'] == "3.3.2"){ $installationtype = "upgrade332"; }      
         if($CSLH_Config['version'] == "3.3.3"){ $installationtype = "upgrade333"; }      
         if($CSLH_Config['version'] == "3.3.4"){ $installationtype = "upgrade334"; }      
         if($CSLH_Config['version'] == "3.3.5"){ $installationtype = "upgrade335"; }      
         if($CSLH_Config['version'] == "3.3.6"){ $installationtype = "upgrade336"; }    
         if($CSLH_Config['version'] == "3.3.7"){ $installationtype = "upgrade337"; }                                      
         if($CSLH_Config['version'] == "3.3.8"){ $installationtype = "upgrade338"; }        
         if($CSLH_Config['version'] == "3.3.9"){ $installationtype = "upgrade339"; } 
         if($CSLH_Config['version'] == "3.3.10"){ $installationtype = "upgrade3310"; }   
         if($CSLH_Config['version'] == "3.3.11"){ $installationtype = "upgrade3311"; }                           
         if($CSLH_Config['version'] == "3.4.0"){ $installationtype = "upgrade340"; }    
         if($CSLH_Config['version'] == "3.4.1"){ $installationtype = "upgrade341"; } 
         if($CSLH_Config['version'] == "3.4.2"){ $installationtype = "upgrade342"; } 
         if($CSLH_Config['version'] == "3.4.3"){ $installationtype = "upgrade343"; }    
         if($CSLH_Config['version'] == "3.4.4"){ $installationtype = "upgrade344"; } 
         if($CSLH_Config['version'] == "3.4.5"){ $installationtype = "upgrade345"; }          
         if($CSLH_Config['version'] == "3.4.6"){ $installationtype = "upgrade346"; }    
         if($CSLH_Config['version'] == "3.4.7"){ $installationtype = "upgrade347"; }             
         if($CSLH_Config['version'] == "3.4.8"){ $installationtype = "upgrade348"; }    
         if($CSLH_Config['version'] == "3.4.9"){ $installationtype = "upgrade349"; }   
         if($CSLH_Config['version'] == "3.5.0"){ $installationtype = "upgrade350"; }  
         if($CSLH_Config['version'] == "3.5.1"){ $installationtype = "upgrade351"; } 
         if($CSLH_Config['version'] == "3.5.2"){ $installationtype = "upgrade352"; } 
         if($CSLH_Config['version'] == "3.5.3"){ $installationtype = "upgrade353"; } 
         if($CSLH_Config['version'] == "3.5.4"){ $installationtype = "upgrade354"; }                   
         if($CSLH_Config['version'] == "3.5.4.unbr"){ $installationtype = "upgrade354"; }                                
         if($CSLH_Config['version'] == "3.6.0"){ $installationtype = "upgrade360"; }  
         if($CSLH_Config['version'] == "3.6.1"){ $installationtype = "upgrade361"; } 		 
         if($CSLH_Config['version'] == "3.6.1.unbr"){ $installationtype = "upgrade361"; } 
         if($CSLH_Config['version'] == "3.6.1.pro"){ $installationtype = "upgrade361"; }          
         if($CSLH_Config['version'] == "3.6.2"){ $installationtype = "upgrade362"; } 
         if($CSLH_Config['version'] == "3.6.2.unbr"){ $installationtype = "upgrade362"; } 
         if($CSLH_Config['version'] == "3.6.2"){ $installationtype = "upgrade362"; }     
         if($CSLH_Config['version'] == "3.7.0"){ $installationtype = "upgrade362"; }              
         if($CSLH_Config['version'] == "3.7.1"){ $installationtype = "upgrade362"; }    
         if($CSLH_Config['version'] == "3.7.4"){ $installationtype = "upgrade362"; }    
         if($CSLH_Config['version'] == "3.7.5"){ $installationtype = "upgrade362"; }   

// <!-- upon new release: add the corrisponding version upgrade lines here -->
               
         
         if( (empty($installationtype)) && (empty($UNTRUSTED['freshinstall'])) ){
         	 print " Error: the version you are upgrading from version <b>" . $CSLH_Config['version']  . "</b> is not known to this install program ";
         	 print " Please visit the website lupopedia.com and download the latest release OR ask CRAFTY SYNTAX ";
         	 print " by emailing <b>lupopedia@gmail.com</b> why this install will not upgrade from version to <b>". $CSLH_Config['version'] ."</b> to $version ";
         	 print " a quick fix for this (although not fully upgraded ) is to just remove the setup.php file ";
         	 exit;
         	}        
         	
          if(!(empty($installationtype))){
         	  $UNTRUSTED['password1'] = "na";
         	  $UNTRUSTED['password2'] = "na";
         	  $UNTRUSTED['email'] = "na";
         	  $UNTRUSTED['homepage'] = "na";
         	  $UNTRUSTED['dbtype_setup'] = "mysql";
         	  $UNTRUSTED['txtpath'] = "";
         	  $UNTRUSTED['dbpath'] = "";
         	  $UNTRUSTED['speaklanguage'] = "";
         	  $UNTRUSTED['username'] = "";
         	  $UNTRUSTED['opening'] = "";
         	  
         	  
         	  $UNTRUSTED['server_setup'] = $server;
            $UNTRUSTED['database_setup'] = $database;
            $UNTRUSTED['datausername_setup'] = $datausername;
            $UNTRUSTED['mypassword_setup'] = $password; 
            $UNTRUSTED['rootpath'] = $application_root;
            $skipwrite = true;
         }
      }   
  }

 
// INSTALL CHECK AND SETUP OF config.php 
//========================================================================================= 
if ($UNTRUSTED['action'] == "INSTALL"){
	
 // check for errors.
 if ($UNTRUSTED['password1'] == ""){  
   $errors .= "<li>You did not enter in a password.";
 }

 if ($UNTRUSTED['password1'] != $UNTRUSTED['password2']){  
    $errors .= "<li>The two passwords you entered do not equal eachother .. you might of mistyped it password the second time . please retype the passwords you entered in again.";
 }

 if(empty($UNTRUSTED['email'])){ $errors .= "<li>You did not enter in a e-mail address. This is important for if you ever lose your password. "; }

 if($UNTRUSTED['dbtype_setup'] == "mysql"){
   if (empty($UNTRUSTED['database_setup'])){ $errors .= "<li>You did not enter in a Mysql database name "; }
   if (empty($UNTRUSTED['datausername_setup'])){ $errors .= "<li>You did not enter in a Mysql Username name "; }        
   if($errors == ""){
     $conn = mysqli_connect($UNTRUSTED['server_setup'],$UNTRUSTED['datausername_setup'],$UNTRUSTED['mypassword_setup'],$UNTRUSTED['database_setup']);	
 
     if(!$conn) {
    	  $errors .= "<li>Connection to the database failed. You may have the wrong database username/password "; 
     } 
     
   } // errors == ""
  } // dbtype_setup = mysql

 if( (empty($UNTRUSTED['homepage']) || ($UNTRUSTED['homepage'] == "http://www.urltoyourwebsite.com"))){ 
	  $errors .= "<li>You did not enter in a valid homepage address. ";
 } 

 if ($errors == ""){
  
  // define undefined:
  if(empty($UNTRUSTED['dbpath'])) 
     $UNTRUSTED['dbpath'] = "";
  if(empty($UNTRUSTED['dbpath_setup'])) 
     $UNTRUSTED['dbpath_setup'] = "";

  // setup the config file..
  $fcontents = @implode ('', @file('config.orig.php'));
  if(empty($fcontents)){
  	$fcontents = "<?php 
 
// set this to true if false you will be re-directed to the setup page
\$installed=true;  

if(empty(\$_SERVER)){ \$_SERVER = \$HTTP_SERVER_VARS; }

// if this program has not been installed and this is not the setup.php
// re-direct to that page to setup database..
if( (\$installed == false) && (!preg_match(\"/setup.php/i\", \$_SERVER['PHP_SELF'])) ){ 
 Header(\"Location: setup.php\");
 exit;
}

// if this file has insecure permissions:
if(\$installed==true){
 \$perm = @stat(\"config.php\");
 if(!(empty(\$perm[2]))){
  if( (\$perm[2] == \"33279\") || (\$perm[2] == \"33278\") || (\$perm[2] == \"33270\")  ){
  	@chmod(\"config.php\", 0755);
  	\$perm = @stat(\"config.php\");
    if(!(empty(\$perm[2]))){
      if( (\$perm[2] == \"33279\") || (\$perm[2] == \"33278\") || (\$perm[2] == \"33270\")  ){
  	      print \"<font color=990000>You must secure this program. Insecure permissions on config.php</font>\";
  	      print \"<br>While installing CSLH you might of needed to change the permissions of config.php so \";
  	      print \"that it is writable by the web server. config.php no longer needs to be written to so \";
  	      print \" please chmod config.php to not have write permissions for everyone. you can do this by\";
  	      print \" UNCHECKING the box that reads write permissions for the file:\";
          print \"<br><br><img src=directions2.gif>\";    
          exit;
       }
     }
    }      
  }
 } 
 
 // dbtype either is either:
 // mysql       - this is for Mysql support
 // txt-db-api  - txt database support. 
 \$dbtype = \"INPUT-DBTYPE\";

 //database connections for MYSQL 
 \$server = \"INPUT-SERVER\";
 \$database = \"INPUT-DATABASE\";
 \$datausername = \"INPUT-DATAUSERNAME\";
 \$password = \"INPUT-PASSWORD\";

 // change this to the full SERVER path to your files 
 // on the server .. not the HTTP PATH.. for example enter in
 // \$application_root = \"/usr/local/apache/htdocs/livehelp/\"
 // not /livehelp/
 // keep ending slash.
 // WINDOWS would look something like:
 // \$application_root = \"D:\\virtual www customers\\craftysyntax\\livehelp_1_6\\\";
 \$application_root = \"INPUT-ROOTPATH\";

 // if using txt-db-api need the path to the txt databases directory
 \$DB_DIR = \"INPUT-TXTPATH\";
 // if using txt-db-api need to have the full path to the txt-db-api
 // you must set this property to something like /home/website/livehelp/txt-db-api/ 
 \$API_HOME_DIR = \"INPUT-ROOTPATH\" . \"txt-db-api/\";
 ?>";
  }
  $fcontents = str_replace("installed=false","installed=true",$fcontents);
  $fcontents = str_replace("INPUT-DBTYPE",addslashes($UNTRUSTED['dbtype_setup']),$fcontents);
  $fcontents = str_replace("INPUT-SERVER",addslashes($UNTRUSTED['server_setup']),$fcontents);
  $fcontents = str_replace("INPUT-DATABASE",addslashes($UNTRUSTED['database_setup']),$fcontents);
  $fcontents = str_replace("INPUT-DATAUSERNAME",addslashes($UNTRUSTED['datausername_setup']),$fcontents);
  $fcontents = str_replace("INPUT-PASSWORD",addslashes($UNTRUSTED['mypassword_setup']),$fcontents);
  $lastchar = substr($UNTRUSTED['txtpath'],-1);
  $txtpath = ($lastchar != C_DIR) ?  $UNTRUSTED['txtpath'] . C_DIR : $UNTRUSTED['txtpath'];
  $lastchar = substr($UNTRUSTED['rootpath'],-1);  
  $rootpath = ($lastchar != C_DIR) ?  $UNTRUSTED['rootpath'] . C_DIR : $UNTRUSTED['rootpath'];
  $lastchar = substr($UNTRUSTED['dbpath'],-1);  
  $dbpath = ($lastchar != C_DIR) ?  $UNTRUSTED['dbpath'] . C_DIR:  $UNTRUSTED['dbpath'];
  $lastchar = substr($UNTRUSTED['homepage'],-1);
  $homepage = ($lastchar != "/") ?  $UNTRUSTED['homepage'] . "/" :  $UNTRUSTED['homepage'];
  
  if(empty($UNTRUSTED['s_homepage']))
     $UNTRUSTED['s_homepage'] = $UNTRUSTED['homepage'];
     
  $lastchar = substr($UNTRUSTED['s_homepage'],-1);
  $s_homepage = ($lastchar != "/") ?  $UNTRUSTED['s_homepage'] . "/" :  $UNTRUSTED['s_homepage'];
   
  $fcontents = str_replace("INPUT-TXTPATH",addslashes($txtpath),$fcontents);
  $fcontents = str_replace("INPUT-ROOTPATH",addslashes($rootpath),$fcontents);
  //$fcontents = str_replace("INPUT-DBPATH",addslashes($dbpath_setup),$fcontents);
  $fcontents = str_replace("INPUT-HTTP",$homepage,$fcontents);
 
  $insert_query = "INSERT INTO livehelp_config (version, site_title, use_flush, membernum, show_typing,webpath,s_webpath,speaklanguage,maxexe,refreshrate,chatmode,adminsession,maxreferers,maxvisits,maxmonths,maxoldhits,maxrecords,admin_refresh,owner_email) VALUES ('$version', 'Live Help!', 'YES', 0, 'Y','".filter_sql($homepage)."','".filter_sql($s_homepage)."','".filter_sql($UNTRUSTED['speaklanguage'])."',180,1,'xmlhttp-flush-refresh','Y',50,75,12,1,75000,'auto','".filter_sql($UNTRUSTED['email'])."')";
  $insert_query2 = "INSERT INTO livehelp_users (username,displayname,password,isonline,isoperator,isadmin,isnamed,email,show_arrival,user_alert,auto_invite,greeting,photo,alertchat,alerttyping,alertinsite) VALUES ('".filter_sql($UNTRUSTED['username'])."','".filter_sql($UNTRUSTED['username'])."','".filter_sql(md5($UNTRUSTED['password1']))."','N','Y','Y','Y','".filter_sql($UNTRUSTED['email'])."','N','A','Y','How may I help You?','','new_chats.wav','click_x.wav','youve_got_visitors.wav')";   
  $insert_query3 = "INSERT INTO livehelp_departments (nameof, onlineimage, offlineimage, requirename, messageemail, leaveamessage, opening, offline, creditline, layerinvite, imagemap,whilewait,timeout,topframeheight,topbackground,topbackcolor,midbackground,midbackcolor,botbackground,botbackcolor,colorscheme,busymess,website) VALUES ('default', 'onoff_images/online1.gif', 'onoff_images/offline1.gif', 'Y', '".filter_sql($UNTRUSTED['email'])."', 'YES', '<blockquote>".filter_sql($UNTRUSTED['opening'])."</blockquote>', '<blockquote>Sorry no operators are currently online to provide Live support at this time.</blockquote>', 'L','dhtmlimage.gif','<MAP NAME=myimagemap><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,0,400,197><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,157,213,257><AREA HREF=javascript:closeDHTML() SHAPE=RECT COORDS=237,157,400,257></MAP>','Please be patient while an operator is contacted... ','150','85','header_images/customersupports.png','#FFFFFF','background_images/chat_bubble_bg.png','#FFFFFF','bottom_images/chat_bubble.png','#F0F0F0','white','<blockquote>Sorry all operators are currently helping other clients and are unable to provide Live support at this time.<br>Would you like to continue to wait for an operator or leave a message?<br><table width=450><tr><td><a href=livehelp.php?page=livehelp.php&department=[department]&tab=1 target=_top><font size=+1>Continue to wait</font></a></td><td align=center><b>or</b></td><td><a href=leavemessage.php?department=[department]><font size=+1>Leave A Message</a></td></tr></table><blockquote>','1')";
  $insert_query4 = "INSERT INTO livehelp_operator_departments (recno, user_id, department, extra) VALUES (1, 1, 1, '')";

  // update the config file.
 if($UNTRUSTED['manualinstall'] != "YES"){
    if(!($skipwrite)){
      $fp = @fopen ("config.php", "w+");
      fwrite($fp,$fcontents);
      fclose($fp);
    }
 } else {
    print "<b>config.php:</b> Select all of the code below and then copy and paste it over your existing config.php file on the server <br><br><font color=990000><b>Note:</b> Be sure there is no Returns or spaces before and after the &lt;?php and ?&gt; markers";
    print "<table bgcolor=DDDDDD><tr><td><pre>" . htmlspecialchars($fcontents) . "</pre></td></tr></table>";
  }
 } // errors == ""
} // action == INSTALL


// INSTALL/UPGRADE DATABASE 
//========================================================================================= 
if ($UNTRUSTED['action'] == "INSTALL"){

 if($errors == ""){
 	 if(empty($installationtype))
   	 $installationtype = $UNTRUSTED['installationtype'];

 
if($installationtype == "newinstall"){

  if( ($UNTRUSTED['dbtype_setup'] == "txt-db-api") && ($errors == "")){
    $lastchar = substr($UNTRUSTED['rootpath'],-1);  
    if($lastchar != "/"){ $UNTRUSTED['rootpath'] .= "/"; }
    $lastchar = substr($UNTRUSTED['txtpath'],-1);  
    if($lastchar != "/"){ $UNTRUSTED['txtpath'] .= "/"; }
    $DB_DIR = $UNTRUSTED['txtpath']; 
    $API_HOME_DIR = $UNTRUSTED['rootpath'] . "txt-db-api/"; 
    define("API_HOME_DIR" ,$API_HOME_DIR);
    define("DB_DIR" ,$DB_DIR);
    define('DB_FETCHMODE_ORDERED', 1);
    define('DB_FETCHMODE_ASSOC', 2);
    include_once("$API_HOME_DIR/resultset.php");
    include_once("$API_HOME_DIR/database.php");
    $mydatabase = new Database("livehelp");	
    $mydatabase->query($insert_query);
    $mydatabase->query($insert_query2);
    $mydatabase->query($insert_query3);
    $mydatabase->query($insert_query4);
    $scratch = "
     Welcome to CRAFTY SYNTAX Live Help 
  
     All the administrative functions are located to the left of this text. 
 
     You can use this section to keep notes for yourself and other admins, etc. 
 
     To change the text that is located in this box just click on the small edit 
     button on the top right corner of this box. 
 
     ";
      $sql = "UPDATE livehelp_config set scratch_space='$scratch',everythingelse='YYYY',admin_refresh='auto'";
        $mydatabase->query($sql);


$mydatabase->query("INSERT INTO livehelp_modules (id,name,path) VALUES (1, 'Live Help!', 'livehelp.php')");
$mydatabase->query("INSERT INTO livehelp_modules (id,name,path) VALUES (2, 'Contact', 'leavemessage.php')");
$mydatabase->query("INSERT INTO livehelp_modules (id,name,path,adminpath) VALUES (3, 'Q & A', 'user_qa.php','qa.php')");
$mydatabase->query("INSERT INTO livehelp_modules_dep VALUES (1, 1, 1, 1, 'N', '')");
$mydatabase->query("INSERT INTO livehelp_modules_dep VALUES (2, 1, 2, 2, 'N', 'Y')");

		$sql = "INSERT INTO livehelp_autoinvite VALUES (1, 'Y', 0, '4', '', 0, '', 'layer','30',0,'N','N','N')";
$mydatabase->query($sql);

		$sql = "INSERT INTO livehelp_questions VALUES (1, 1, 0, 'E-mail:', 'email', '', '', 'leavemessage', 'Y')";
    $mydatabase->query($sql);
		$sql = "INSERT INTO livehelp_questions VALUES (2, 1, 0, 'Question:', 'textarea', '', '', 'leavemessage', 'N')";
    $mydatabase->query($sql);
		$sql = "INSERT INTO livehelp_questions VALUES (3, 1, 0, 'Name', 'username', '', '', 'livehelp', 'N')";
    $mydatabase->query($sql);
	//	$sql = "INSERT INTO livehelp_questions VALUES (4, 1, 1, 'E-mail', 'email', '', '', 'livehelp', 'N')";
  //  $mydatabase->query($sql);
    $sql = "INSERT INTO livehelp_questions VALUES (5, 1, 1, 'Question', 'textarea', '', '', 'livehelp', 'N')";
    $mydatabase->query($sql);
    $sql = "UPDATE livehelp_departments set showtimestamp='N',leavetxt='<h3><SPAN CLASS=wh>LEAVE A MESSAGE:</SPAN></h3>Please type in your comments/questions in the box below <br> and provide an e-mail address so we can get back to you'";
    $mydatabase->query($sql);		 
    $sql = "UPDATE livehelp_departments set topframeheight='85',topbackground='header_images/customersupports.png',colorscheme='white'";
   $mydatabase->query($sql);  

} // END: $UNTRUSTED['dbtype_setup'] == "txt-db-api") && ($errors == "")

if ($UNTRUSTED['dbtype_setup'] == "mysql"){
  if($errors == ""){


   $sql = "DROP TABLE IF EXISTS livehelp_paths_firsts";
   $results = $conn->query($sql); 
   $sql = "CREATE TABLE `livehelp_paths_firsts` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `visit_recno` int(11) unsigned NOT NULL default '0',
  `exit_recno` int(11) unsigned NOT NULL default '0',
  `dateof` int(8) NOT NULL default '0',
  `visits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `visit_recno` (`visit_recno`,`dateof`,`visits`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql);


   $sql = "DROP TABLE IF EXISTS livehelp_paths_monthly";
   $results = $conn->query($sql);    
  $sql = "CREATE TABLE `livehelp_paths_monthly` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `visit_recno` int(11) unsigned NOT NULL default '0',
  `exit_recno` int(11) unsigned NOT NULL default '0',
  `dateof` int(8) NOT NULL default '0',
  `visits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `visit_recno` (`visit_recno`),
  KEY `dateof` (`dateof`),
  KEY `visits` (`visits`)  
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql);

   $sql = "DROP TABLE IF EXISTS livehelp_sessions";
   $results = $conn->query($sql); 
   $sql = "CREATE TABLE `livehelp_sessions` (
  `session_id` varchar(100) NOT NULL default '',
  `session_data` text NOT NULL,
  `expires` int(11) NOT NULL default '0',
   PRIMARY KEY  (`session_id`),
   KEY `expires` (`expires`)
   ) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql);
         
   $sql = "DROP TABLE IF EXISTS livehelp_leavemessage";
   $results = $conn->query($sql);  
 	$sql = "
  CREATE TABLE `livehelp_leavemessage` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `email` varchar(255) NOT NULL default '',
  `subject` varchar(200) NOT NULL default '',
  `department` int(11) unsigned NOT NULL default '0',
  `dateof` bigint(14) NOT NULL default '0',
  `sessiondata` text NULL,
  `deliminated` text NULL,  
  PRIMARY KEY  (`id`),
  KEY `department` (`department`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
  	";
    $results = $conn->query($sql);   

   $sql = "DROP TABLE IF EXISTS livehelp_keywords_daily";
   $results = $conn->query($sql);   
   	$sql = "
CREATE TABLE `livehelp_keywords_daily` (
  `recno` int(11) NOT NULL auto_increment,
  `parentrec` int(11) unsigned NOT NULL default '0',
  `referer` varchar(255) NOT NULL default '',
  `pageurl` varchar(255) NOT NULL default '',
  `keywords` varchar(255) NOT NULL default '',
  `dateof` int(8) NOT NULL default '0',
  `levelvisits` int(11) unsigned NOT NULL default '0',
  `directvisits` int(11) unsigned NOT NULL default '0',
  `department` INT( 11 ) DEFAULT '0' NOT NULL,
  PRIMARY KEY  (`recno`),
  KEY `department` (`department`),
  KEY `levelvisits` (`levelvisits`),
  KEY `dateof` (`dateof`),
  KEY `referer` (`referer`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
  	";
    $results = $conn->query($sql);  
 
    $sql = "DROP TABLE IF EXISTS livehelp_keywords_monthly";
   $results = $conn->query($sql); 
    	$sql = "
CREATE TABLE `livehelp_keywords_monthly` (
  `recno` int(11) NOT NULL auto_increment,
  `parentrec` int(11) unsigned NOT NULL default '0',
  `referer` varchar(255) NOT NULL default '',
  `pageurl` varchar(255) NOT NULL default '',
  `keywords` varchar(255) NOT NULL default '',
  `dateof` int(8) NOT NULL default '0',
  `levelvisits` int(11) unsigned NOT NULL default '0',
  `directvisits` int(11) unsigned NOT NULL default '0',
  `department` INT( 11 ) DEFAULT '0' NOT NULL,
  PRIMARY KEY  (`recno`),
  KEY `department` (`department`),  
  KEY `levelvisits` (`levelvisits`),
  KEY `dateof` (`dateof`),
  KEY `referer` (`referer`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
  	";
    $results = $conn->query($sql);  
 
  
   $sql = "DROP TABLE IF EXISTS livehelp_identity_daily";
   $results = $conn->query($sql);  
    $sql = "CREATE TABLE `livehelp_identity_daily` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `isnamed` char(1) NOT NULL default 'N',
  `groupidentity` int(11) NOT NULL default '0',
  `groupusername` int(11) NOT NULL default '0',
  `identity` varchar(100) NOT NULL default '',
  `cookieid` varchar(40) NOT NULL default '',
  `ipaddress` varchar(30) NOT NULL default '',
  `username` varchar(100) NOT NULL default '',
  `dateof` bigint(14) NOT NULL default '0',
  `uservisits` int(10) NOT NULL default '0',
  `seconds` int(10) NOT NULL default '0',
  `useragent` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `isnamed` (`isnamed`),
  KEY `groupidentity` (`groupidentity`),
  KEY `groupusername` (`groupusername`),
  KEY `identity` (`identity`),
  KEY `cookieid` (`cookieid`),
  KEY `username` (`username`),
  KEY `dateof` (`dateof`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
    $results = $conn->query($sql);

   $sql = "DROP TABLE IF EXISTS livehelp_identity_monthly";
   $results = $conn->query($sql);  
    $sql = "CREATE TABLE `livehelp_identity_monthly` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `isnamed` char(1) NOT NULL default 'N',
  `groupidentity` int(11) NOT NULL default '0',
  `groupusername` int(11) NOT NULL default '0',
  `identity` varchar(100) NOT NULL default '',
  `cookieid` varchar(40) NOT NULL default '',
  `ipaddress` varchar(30) NOT NULL default '',
  `username` varchar(100) NOT NULL default '',
  `dateof` bigint(14) NOT NULL default '0',
  `uservisits` int(10) NOT NULL default '0',
  `seconds` int(10) NOT NULL default '0',
  `useragent` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `isnamed` (`isnamed`),
  KEY `groupidentity` (`groupidentity`),
  KEY `groupusername` (`groupusername`),
  KEY `identity` (`identity`),
  KEY `cookieid` (`cookieid`),
  KEY `username` (`username`),
  KEY `dateof` (`dateof`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
    $results = $conn->query($sql);

   $sql = "DROP TABLE IF EXISTS livehelp_referers_monthly";
   $results = $conn->query($sql);   
  $sql = "
   CREATE TABLE `livehelp_referers_monthly` (
  `recno` int(11) NOT NULL auto_increment,
  `pageurl` varchar(255) NOT NULL default '0',
  `dateof` int(8) NOT NULL default '0',
  `levelvisits` int(11) unsigned NOT NULL default '0',
  `directvisits` int(11) unsigned NOT NULL default '0',
  `parentrec` int(11) unsigned NOT NULL default '0',
  `level` int(10) NOT NULL default '0',
  `department` INT( 11 ) DEFAULT '0' NOT NULL,
  PRIMARY KEY  (`recno`),
  KEY `department` (`department`),  
  KEY `pageurl` (`pageurl`),
  KEY `parentrec` (`parentrec`),
  KEY `levelvisits` (`levelvisits`),
  KEY `directvisits` (`directvisits`),
  KEY `dateof` (`dateof`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql); 

   $sql = "DROP TABLE IF EXISTS livehelp_referers_daily";
   $results = $conn->query($sql);   
  $sql = "
  CREATE TABLE `livehelp_referers_daily` (
  `recno` int(11) NOT NULL auto_increment,
  `pageurl` varchar(255) NOT NULL default '0',
  `dateof` int(8) NOT NULL default '0',
  `levelvisits` int(11) unsigned NOT NULL default '0',
  `directvisits` int(11) unsigned NOT NULL default '0',
  `parentrec` int(11) unsigned NOT NULL default '0',
  `level` int(10) NOT NULL default '0',
  `department` INT( 11 ) DEFAULT '0' NOT NULL,
  PRIMARY KEY  (`recno`),
  KEY `department` (`department`),  
  KEY `pageurl` (`pageurl`),
  KEY `parentrec` (`parentrec`),
  KEY `levelvisits` (`levelvisits`),
  KEY `directvisits` (`directvisits`),
  KEY `dateof` (`dateof`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql); 

   $sql = "DROP TABLE IF EXISTS livehelp_visits_monthly";
   $results = $conn->query($sql);
  $sql = "
   CREATE TABLE `livehelp_visits_monthly` (
  `recno` int(11) NOT NULL auto_increment,
  `pageurl` varchar(255) NOT NULL default '0',
  `dateof` int(8) NOT NULL default '0',
  `levelvisits` int(11) unsigned NOT NULL default '0',
  `directvisits` int(11) unsigned NOT NULL default '0',
  `parentrec` int(11) unsigned NOT NULL default '0',
  `level` int(10) NOT NULL default '0',
  `department` INT( 11 ) DEFAULT '0' NOT NULL,
  PRIMARY KEY  (`recno`),
  KEY `department` (`department`),  
  KEY `pageurl` (`pageurl`),
  KEY `parentrec` (`parentrec`),
  KEY `levelvisits` (`levelvisits`),
  KEY `directvisits` (`directvisits`),
  KEY `dateof` (`dateof`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql); 

   $sql = "DROP TABLE IF EXISTS livehelp_visits_daily";
   $results = $conn->query($sql);   
  $sql = "
  CREATE TABLE `livehelp_visits_daily` (
  `recno` int(11) NOT NULL auto_increment,
  `pageurl` varchar(255) NOT NULL default '0',
  `dateof` int(8) NOT NULL default '0',
  `levelvisits` int(11) unsigned NOT NULL default '0',
  `directvisits` int(11) unsigned NOT NULL default '0',
  `parentrec` int(11) unsigned NOT NULL default '0',
  `level` int(10) NOT NULL default '0',
  `department` INT( 11 ) DEFAULT '0' NOT NULL,
  PRIMARY KEY  (`recno`),
  KEY `department` (`department`),  
  KEY `pageurl` (`pageurl`),
  KEY `parentrec` (`parentrec`),
  KEY `levelvisits` (`levelvisits`),
  KEY `directvisits` (`directvisits`),
  KEY `dateof` (`dateof`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql); 
   
   $sql = "DROP TABLE IF EXISTS livehelp_layerinvites";
   $results = $conn->query($sql);
   $sql = "
    CREATE TABLE `livehelp_layerinvites` (
  `layerid` int(10) NOT NULL default '0',
  `name` varchar(60) NOT NULL default '',
  `imagename` varchar(60) NOT NULL default '',
  `imagemap` text NULL,
  `department` varchar(60) NOT NULL default '',
  `user` int(10) NOT NULL default '0',
  PRIMARY KEY  (`layerid`)
   ) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql); 
      
  $sql = "DROP TABLE IF EXISTS livehelp_operator_history";
  $results = $conn->query($sql);
    $sql = "
CREATE TABLE `livehelp_operator_history` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `opid` int(11) unsigned NOT NULL default '0',
  `action` varchar(60) NOT NULL default '',
  `dateof` bigint(14) NOT NULL default '0',
  `sessionid` varchar(40) NOT NULL default '',
  `transcriptid` int(10) NOT NULL default '0',
  `totaltime` int(10) NOT NULL default '0',
  `channel` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  INDEX ( `opid` ), 
  INDEX ( `dateof` )         
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
    ";
    $results = $conn->query($sql);
 
  $sql = "DROP TABLE IF EXISTS livehelp_websites";
  $results = $conn->query($sql);
    $sql = "
CREATE TABLE IF NOT EXISTS `livehelp_websites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_name` varchar(45) NOT NULL,
  `site_url` varchar(255) NOT NULL,
  `defaultdepartment` int(8) NOT NULL,  
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
 ";
    $results = $conn->query($sql);
    
    
  $sql = "DROP TABLE IF EXISTS livehelp_questions";
  $results = $conn->query($sql);
    $sql = "
         CREATE TABLE `livehelp_questions` (
      `id` INT( 10 ) NOT NULL AUTO_INCREMENT,
      `department` INT( 10 ) NOT NULL default '0',
      `ordering` INT( 8 ) NOT NULL default '0',
      `headertext` TEXT NULL,
      `fieldtype` VARCHAR( 30 ) NOT NULL default '',
      `options` TEXT NULL,
      `flags` VARCHAR( 60 ) NOT NULL default '',
      `module` VARCHAR( 60 ) NOT NULL default '',
      `required` CHAR( 1 ) DEFAULT 'N' NOT NULL,
      PRIMARY KEY ( `id` ) ,
      INDEX ( `department` ) 
      )ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

    ";
    $results = $conn->query($sql);
    
  $sql = "DROP TABLE IF EXISTS livehelp_smilies";
  $results = $conn->query($sql);
    $sql = 
       "CREATE TABLE `livehelp_smilies` (
        `smilies_id` smallint(5) unsigned NOT NULL auto_increment,
        `code` varchar(50) default NULL,
        `smile_url` varchar(100) default NULL,
        `emoticon` varchar(75) default NULL,
        PRIMARY KEY  (`smilies_id`)
       )ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
       ";
 		   $conn->query($sql);
  		$sql = "INSERT INTO `livehelp_smilies` VALUES (1, ':D', 'icon_biggrin.gif', 'Very Happy')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (2, ':-D', 'icon_biggrin.gif', 'Very Happy')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (3, ':grin:', 'icon_biggrin.gif', 'Very Happy')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (4, ':)', 'icon_smile.gif', 'Smile')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (5, ':-)', 'icon_smile.gif', 'Smile')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (6, ':smile:', 'icon_smile.gif', 'Smile')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (7, ':(', 'icon_sad.gif', 'Sad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (8, ':-(', 'icon_sad.gif', 'Sad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (9, ':sad:', 'icon_sad.gif', 'Sad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (10, ':o', 'icon_surprised.gif', 'Surprised')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (11, ':-o', 'icon_surprised.gif', 'Surprised')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (12, ':eek:', 'icon_surprised.gif', 'Surprised')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (13, ':shock:', 'icon_eek.gif', 'Shocked')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (14, ':?', 'icon_confused.gif', 'Confused')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (15, ':-?', 'icon_confused.gif', 'Confused')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (16, ':???:', 'icon_confused.gif', 'Confused')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (17, '8)', 'icon_cool.gif', 'Cool')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (18, '8-)', 'icon_cool.gif', 'Cool')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (19, ':cool:', 'icon_cool.gif', 'Cool')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (20, ':lol:', 'icon_lol.gif', 'Laughing')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (21, ':x', 'icon_mad.gif', 'Mad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (22, ':-x', 'icon_mad.gif', 'Mad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (23, ':mad:', 'icon_mad.gif', 'Mad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (24, ':P', 'icon_razz.gif', 'Razz')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (25, ':-P', 'icon_razz.gif', 'Razz')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (26, ':razz:', 'icon_razz.gif', 'Razz')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (27, ':oops:', 'icon_redface.gif', 'Embarassed')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (28, ':cry:', 'icon_cry.gif', 'Crying or Very sad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (29, ':evil:', 'icon_evil.gif', 'Evil or Very Mad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (30, ':twisted:', 'icon_twisted.gif', 'Twisted Evil')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (31, ':roll:', 'icon_rolleyes.gif', 'Rolling Eyes')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (32, ':wink:', 'icon_wink.gif', 'Wink')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (33, ';)', 'icon_wink.gif', 'Wink')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (34, ';-)', 'icon_wink.gif', 'Wink')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (35, ':!:', 'icon_exclaim.gif', 'Exclamation')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (36, ':?:', 'icon_question.gif', 'Question')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (37, ':idea:', 'icon_idea.gif', 'Idea')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (38, ':arrow:', 'icon_arrow.gif', 'Arrow')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (39, ':|', 'icon_neutral.gif', 'Neutral')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (40, ':-|', 'icon_neutral.gif', 'Neutral')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (41, ':neutral:', 'icon_neutral.gif', 'Neutral')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (42, ':mrgreen:', 'icon_mrgreen.gif', 'Mr. Green')";
 		$conn->query($sql);
     
     
    $sql = "DROP TABLE IF EXISTS livehelp_autoinvite";
    $results = $conn->query($sql);
    $sql = 
    "CREATE TABLE IF NOT EXISTS `livehelp_autoinvite` (
  `idnum` int(10) NOT NULL AUTO_INCREMENT,
  `offline` int(1) NOT NULL DEFAULT '0',
  `isactive` char(1) NOT NULL DEFAULT '',
  `department` int(10) NOT NULL DEFAULT '0',
  `message` text,
  `page` varchar(255) NOT NULL DEFAULT '',
  `visits` int(8) NOT NULL DEFAULT '0',
  `referer` varchar(255) NOT NULL DEFAULT '',
  `typeof` varchar(255) NOT NULL DEFAULT '',
  `seconds` int(11) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) NOT NULL DEFAULT '0',
  `socialpane` char(1) NOT NULL DEFAULT 'N',
  `excludemobile` char(1) NOT NULL DEFAULT 'N',
  `onlymobile` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`idnum`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1; ";
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}

$sql = "DROP TABLE IF EXISTS livehelp_modules_dep";
$results = $conn->query($sql);
$sql = 
"CREATE TABLE livehelp_modules_dep (
  rec int(10) NOT NULL auto_increment,
  departmentid int(10) NOT NULL default '0',
  modid int(10) NOT NULL default '0',
  ordernum int(8) NOT NULL default '0',
  isactive char(1) NOT NULL default 'N',
  defaultset char(1) NOT NULL default '',
  PRIMARY KEY  (rec)
)ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1; 
";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}

$sql = "DROP TABLE IF EXISTS livehelp_modules";
$results = $conn->query($sql);
$sql = 
"CREATE TABLE livehelp_modules (
  id int(10) NOT NULL auto_increment,
  name varchar(30) NOT NULL default '',
  path varchar(255) NOT NULL default '',
  adminpath varchar(255) NOT NULL default '',
  query_string varchar(255) NOT NULL default '',  
  PRIMARY KEY  (id)
)ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;  
";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}
$sql = "INSERT INTO `livehelp_modules` (id,name,path) VALUES (1, 'Live Help!', 'livehelp.php')";
$conn->query($sql);
$sql = "INSERT INTO `livehelp_modules` (id,name,path) VALUES (2, 'Contact', 'leavemessage.php')";
$conn->query($sql);

$sql = "INSERT INTO `livehelp_modules` (id,name,path,adminpath) VALUES (3, 'Q & A', 'user_qa.php','qa.php')";
$conn->query($sql);
$sql = "INSERT INTO `livehelp_modules_dep` VALUES (1, 1, 1, 1, 'N', '')";
$conn->query($sql);
$sql = "INSERT INTO `livehelp_modules_dep` VALUES (2, 1, 2, 2, 'N', 'Y')";
		$conn->query($sql);
	
$sql = "DROP TABLE IF EXISTS livehelp_channels";
$results = $conn->query($sql);
$sql = 
"CREATE TABLE livehelp_channels (
  id int(10) NOT NULL auto_increment,
  user_id int(10) NOT NULL default '0',
  statusof char(1) NOT NULL default '',
  startdate bigint(8) NOT NULL default '0',
  `sessionid` VARCHAR( 40 ) NOT NULL default '',
  `website` INT(8) NOT NULL default '0',
  PRIMARY KEY  (id)
)ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}
		
$sql = "DROP TABLE IF EXISTS livehelp_config";
$results = $conn->query($sql);  
// <!-- upon new release: increase the default version number here  -->
  $sql  =  
"CREATE TABLE `livehelp_config` (
  `version` varchar(25) NOT NULL default '3.7.5',
  `site_title` varchar(100) NOT NULL default '',
  `use_flush` varchar(10) NOT NULL default 'YES',
  `membernum` int(8) NOT NULL default '0',
  `show_typing` char(1) NOT NULL default '',
  `webpath` varchar(255) NOT NULL default '',
  `s_webpath` varchar(255) NOT NULL default '',
  `speaklanguage` varchar(60) NOT NULL default 'English',
  `scratch_space` text NULL,
  `admin_refresh` varchar(30) NOT NULL default 'auto',
  `maxexe` int(5) default '180',
  `refreshrate` int(5) NOT NULL default '1',
  `chatmode` varchar(60) NOT NULL default 'xmlhttp-flush-refresh',
  `adminsession` char(1) NOT NULL default 'Y',
  `ignoreips` text NULL,
  `directoryid` varchar(32) NOT NULL default '',
  `tracking` char(1) NOT NULL default 'N',
  `colorscheme` varchar(30) NOT NULL default 'white',
  `matchip` char(1) NOT NULL default 'N',
  `gethostnames` char(1) NOT NULL default 'N',
  `maxrecords` int(10) NOT NULL default '75000',
  `maxreferers` int(10) NOT NULL default '50',
  `maxvisits` int(10) NOT NULL default '75',
  `maxmonths` int(10) NOT NULL default '12',
  `maxoldhits` int(10) NOT NULL default '1',
  `showgames` char(1) NOT NULL default 'Y',
  `showsearch` char(1) NOT NULL default 'Y',
  `showdirectory` char(1) NOT NULL default 'Y',
  `usertracking` char(1) NOT NULL default 'N',
  `resetbutton` char(1) NOT NULL default 'N',
  `keywordtrack` char(1) NOT NULL default 'N',
  `reftracking` char(1) NOT NULL default 'N',
  `topkeywords` int(10) NOT NULL default '50',
  `everythingelse` text NULL,
  `rememberusers` char(1) NOT NULL default 'Y',
  `smtp_host` VARCHAR( 255 ) NOT NULL default '',
  `smtp_username` VARCHAR( 60 ) NOT NULL default '',
  `smtp_password` VARCHAR( 60 ) NOT NULL default '',
  `owner_email` VARCHAR( 255 ) NOT NULL default '',
  `topframeheight` INT( 8 ) NOT NULL default '85',
  `topbackground` VARCHAR( 156 ) NOT NULL default 'header_images/customersupports.png',
  `usecookies` CHAR( 1 ) NOT NULL DEFAULT 'Y',  
  `smtp_portnum` int( 10 ) NOT NULL default '25',
  `showoperator` CHAR( 1 ) NOT NULL DEFAULT 'Y',  
  `chatcolors` text NULL,
  `floatxy`  VARCHAR( 42 ) NOT NULL DEFAULT '200|160',
  `sessiontimeout` INT( 8 ) NOT NULL DEFAULT '60',
  `theme` VARCHAR( 42 ) NOT NULL DEFAULT 'vanilla',  
  `operatorstimeout` INT(4) NOT NULL DEFAULT '4',
  `operatorssessionout` INT(8) NOT NULL DEFAULT '45',  
  `maxrequests` INT( 8 ) NOT NULL DEFAULT '99999',
  `ignoreagent` text NULL,
  PRIMARY KEY  (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}
    if (!$conn->query($insert_query)) {
      die('Insert into livehelp_config failed: ' . $conn->error);
   }
 
$sql = "DROP TABLE IF EXISTS livehelp_departments";
$results = $conn->query($sql); 
$sql  =  
"CREATE TABLE `livehelp_departments` (
  `recno` int(5) NOT NULL auto_increment,
  `nameof` varchar(30) NOT NULL default '',
  `onlineimage` varchar(255) NOT NULL default '',
  `offlineimage` varchar(255) NOT NULL default '',
  `layerinvite` varchar(255) NOT NULL default '',
  `requirename` char(1) NOT NULL default '',
  `messageemail` varchar(60) NOT NULL default '',
  `leaveamessage` varchar(10) NOT NULL default '',
  `opening` text NULL,
  `offline` text NULL,
  `creditline` char(1) NOT NULL default 'L',
  `imagemap` text NULL,
  `whilewait` text NULL,
  `timeout` int(5) NOT NULL default '150',
  `leavetxt` text NULL,
  `topframeheight` int(10) NOT NULL default '85',
  `topbackground` varchar(255) NOT NULL default '',
  `botbackground` VARCHAR( 255 ) NOT NULL DEFAULT '',
  `midbackground` VARCHAR( 255 ) NOT NULL DEFAULT '',
  `topbackcolor` VARCHAR( 255 ) NOT NULL DEFAULT '',
  `midbackcolor` VARCHAR( 255 ) NOT NULL DEFAULT '',      
  `botbackcolor` VARCHAR( 255 ) NOT NULL DEFAULT '',  
  `colorscheme` varchar(255) NOT NULL default '',
  `speaklanguage` varchar(60) NOT NULL default '',
  `busymess` text NULL,
  `emailfun` char(1) NOT NULL default 'Y',
  `dbfun` char(1) NOT NULL default 'Y',
  `everythingelse` text NULL,
  `ordering` INT( 8 ) NOT NULL default '0',
  `smiles` CHAR( 1 ) NOT NULL DEFAULT 'Y',
  `visible` INT( 1 ) DEFAULT '1' NOT NULL,   
  `theme` VARCHAR(45) DEFAULT 'vanilla' NOT NULL,   
  `showtimestamp` CHAR( 1 ) NOT NULL DEFAULT 'N',
  `website` INT(8) NOT NULL default '1',
  PRIMARY KEY  (`recno`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}
  $sql = "DROP TABLE IF EXISTS livehelp_messages";
$results = $conn->query($sql);   
  $sql  =  
"CREATE TABLE livehelp_messages (
  id_num int(10) NOT NULL auto_increment,
  message text NULL,
  channel int(10) NOT NULL default '0',
  timeof bigint(14) NOT NULL default '0',
  saidfrom int(10) NOT NULL default '0',
  saidto int(10) NOT NULL default '0',
  typeof varchar(30) NOT NULL default '',
  PRIMARY KEY  (id_num),
  KEY channel (channel),
  KEY timeof (timeof)
)ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}
  $sql = "DROP TABLE IF EXISTS livehelp_operator_channels";
$results = $conn->query($sql);  
$sql  =  
"CREATE TABLE livehelp_operator_channels (
  id int(10) NOT NULL auto_increment,
  user_id int(10) NOT NULL default '0',
  channel int(10) NOT NULL default '0',
  userid int(10) NOT NULL default '0',
  statusof char(1) NOT NULL default '',
  startdate bigint(8) NOT NULL default '0',
  bgcolor varchar(10) NOT NULL default '000000',
  txtcolor varchar(10) NOT NULL default '000000',
  channelcolor varchar(10) NOT NULL default 'F7FAFF',  
  txtcolor_alt varchar(10) NOT NULL default '000000', 
  PRIMARY KEY  (id),
  KEY channel (channel),
  KEY user_id (user_id)
)ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}	 
  $sql = "DROP TABLE IF EXISTS livehelp_operator_departments";
$results = $conn->query($sql);  
$sql  =  
"CREATE TABLE livehelp_operator_departments (
  recno int(10) NOT NULL auto_increment,
  user_id int(10) NOT NULL default '0',
  department int(10) NOT NULL default '0',
  extra varchar(100) NOT NULL default '',
  PRIMARY KEY  (recno),
  KEY user_id (user_id),
  KEY department (department)
)ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}
  $sql = "DROP TABLE IF EXISTS livehelp_qa";
$results = $conn->query($sql);  
$sql  =  
"CREATE TABLE livehelp_qa (
  recno int(10) NOT NULL auto_increment,
  parent int(10) NOT NULL default '0',
  question text NULL,
  typeof varchar(10) NOT NULL default '',
  status VARCHAR(20) NOT NULL default '',
  username varchar(60) NOT NULL default '',
  ordernum int(10) NOT NULL default '0',   
  PRIMARY KEY  (recno)
)ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}

  $sql = "DROP TABLE IF EXISTS livehelp_quick";
$results = $conn->query($sql); 		
  $sql  = 
"CREATE TABLE livehelp_quick (
  id int(10) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  typeof varchar(30) NOT NULL default '',
  message text NULL,
  visiblity varchar(20) NOT NULL default '',
  department varchar(60) NOT NULL default '0',
  user int(10) NOT NULL default '0',
  ishtml varchar(3) NOT NULL default '',
  PRIMARY KEY  (id)
)ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}
	
 
$sql = "DROP TABLE IF EXISTS livehelp_transcripts";
$results = $conn->query($sql); 	
  $sql  =  	
"CREATE TABLE `livehelp_transcripts` (
  `recno` int(10) NOT NULL auto_increment,
  `who` varchar(100) NOT NULL default '',
  `endtime` bigint(14) default NULL,
  `transcript` text NULL,
  `sessionid` varchar(40) NOT NULL default '',
  `sessiondata` text NULL,
  `department` int(10) NOT NULL default '0',
  `email` varchar(100) NOT NULL default '',
  `starttime` bigint(14) NOT NULL default '0',
  `duration` int(11) unsigned NOT NULL default '0',
  `operators` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`recno`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}

$sql = "DROP TABLE IF EXISTS livehelp_emailque";
$results = $conn->query($sql); 			
 	  $sql  =  
"CREATE TABLE IF NOT EXISTS `livehelp_emailque` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `messageid` int(8) NOT NULL,
  `towho` varchar(60) NOT NULL,
  `dateof` int(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `messageid` (`messageid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}	
 		
 
$sql = "DROP TABLE IF EXISTS livehelp_emails";
$results = $conn->query($sql); 			
  $sql  =  
"CREATE TABLE IF NOT EXISTS `livehelp_emails` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `fromemail` varchar(60) NOT NULL,
  `subject` varchar(60) NOT NULL,
  `bodyof` text NOT NULL,
  `notes` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}	

$sql = "DROP TABLE IF EXISTS livehelp_leads";
$results = $conn->query($sql); 			
  $sql  =  	
"CREATE TABLE IF NOT EXISTS `livehelp_leads` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `email` varchar(90) NOT NULL,
  `phone` varchar(90) NOT NULL,  
  `source` varchar(45) NOT NULL,
  `status` varchar(10) NOT NULL,
  `data` TEXT NOT NULL,
  `firstname` varchar(40) NOT NULL,
  `lastname` varchar(40) NOT NULL,
  `date_entered` int(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `email` (`email`,`source`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}	

$sql = "DROP TABLE IF EXISTS livehelp_users";
$results = $conn->query($sql); 			
  $sql  =  	
"CREATE TABLE livehelp_users (
  user_id int(10) NOT NULL auto_increment,
  lastaction BIGINT(14) DEFAULT '0',
  username varchar(30) NOT NULL default '',
  `displayname` VARCHAR(42) NOT NULL default '',
  password varchar(60) NOT NULL default '',
  isonline char(1) NOT NULL default '',
  isoperator char(1) NOT NULL default 'N',
  onchannel int(10) NOT NULL default '0',
  isadmin char(1) NOT NULL default 'N',
  department int(5) NOT NULL default '0',
  identity varchar(255) NOT NULL default '',
  status varchar(30) NOT NULL default '',
  isnamed char(1) NOT NULL default 'N',
  showedup bigint(14) default NULL,
  email varchar(60) NOT NULL default '',
  camefrom varchar(255) NOT NULL default '',
  show_arrival char(1) NOT NULL default 'N',
  user_alert char(1) NOT NULL default 'A',
  auto_invite CHAR( 1 ) NOT NULL default 'N',
  istyping  CHAR( 1 ) NOT NULL default '3',
  visits int(8) NOT NULL default '0',
  jsrn int(5) NOT NULL default '0',
  hostname varchar(255) NOT NULL default '',
  useragent varchar(255) NOT NULL default '',
  ipaddress varchar(255) NOT NULL default '',  
  `sessionid` varchar(40) NOT NULL default '',
  `typing_alert` CHAR( 1 ) NOT NULL DEFAULT 'N',  
  `authenticated` char(1) NOT NULL default '',
  `cookied` CHAR( 1 ) DEFAULT 'N' NOT NULL,
  sessiondata text NULL,
  expires bigint(14) NOT NULL default '0',
  `greeting` text NULL,
  photo varchar(255) NOT NULL default '',
  chataction BIGINT(14) DEFAULT '0',
  `new_session` CHAR( 1 ) NOT NULL DEFAULT 'Y',
  `showtype` INT( 10 ) NOT NULL DEFAULT '1',
  `chattype` CHAR( 1 ) NOT NULL DEFAULT 'Y',
  `externalchats` VARCHAR( 255 ) NOT NULL DEFAULT '',  
  `layerinvite` INT( 10 ) DEFAULT '0' NOT NULL,
  `askquestions` CHAR( 1 ) DEFAULT 'Y' NOT NULL,
  `showvisitors` CHAR( 1 ) DEFAULT 'N' NOT NULL,
  `cookieid` VARCHAR( 40 ) NOT NULL default '',
  `cellphone` VARCHAR( 255 ) NOT NULL DEFAULT '', 
  `lastcalled` bigint(14) NOT NULL default '0',
  `ismobile` char(1) DEFAULT 'N',  
  `cell_invite` char(1) DEFAULT 'N',  
  `useimage` CHAR(1) DEFAULT 'N' NOT NULL, 
  `firstdepartment` INT( 11 ) DEFAULT '0' NOT NULL,
  `alertchat` VARCHAR( 45 ) NOT NULL DEFAULT '', 
  `alerttyping` VARCHAR( 45 ) NOT NULL DEFAULT '',
  `alertinsite` VARCHAR( 45 ) NOT NULL DEFAULT '',      
  PRIMARY KEY  (user_id),
  KEY expires (expires),
  KEY sessionid (sessionid)  
)ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}		
$sql = "DROP TABLE IF EXISTS livehelp_visit_track";
$results = $conn->query($sql); 	
  $sql  =  
"CREATE TABLE livehelp_visit_track (
  recno int(10) NOT NULL auto_increment,
  sessionid varchar(40) NOT NULL default '0',
  location varchar(255) NOT NULL default '',
  page bigint(14) NOT NULL default '0',
  title varchar(100) NOT NULL default '',
  whendone BIGINT( 14 ) NOT NULL default '0',
  referrer varchar(255) NOT NULL default '',
  PRIMARY KEY  (recno),
  KEY sessionid (sessionid),
  KEY `location` (`location`),
  KEY `page` (`page`),
  KEY `whendone` (`whendone`) 
)ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}		
 
        $scratch = "
 Welcome to CRAFTY SYNTAX Live Help 

 All the administrative functions are located to the left of this text. 
 
You can use this section to keep notes for yourself and other admins, etc. 
 
To change the text that is located in this box just click on the small edit 
button on the top right corner of this box. 
        ";
        $sql = "UPDATE livehelp_config set showoperator='Y',scratch_space='$scratch'";
        $results = $conn->query($sql);
// default stuff...  				        
    $sql = "UPDATE `livehelp_config` SET chatcolors='fefdcd,cbcefe,caedbe,cccbba,aecddc,EBBEAA,faacaa,fbddef,cfaaef,aedcbd,bbffff,fedabf;040662,240462,520500,404062,100321,662640,242642,151035,051411,442662,442022,200220;426446,224646,466286,828468,866482,484668,504342,224882,486882,824864,668266,444468'";
    $results = $conn->query($sql);

       
    $conn->query($insert_query2);       
    $conn->query($insert_query3);
     $conn->query($insert_query4); 		 
 	
		$sql = "INSERT INTO `livehelp_autoinvite` VALUES (1, 0, 'Y', 0, '4', '', 0, '', 'layer','30',0,'N','N','N')";
    $results = $conn->query($sql);

		$sql = "INSERT INTO `livehelp_questions` VALUES (1, 1, 0, 'E-mail:', 'email', '', '', 'leavemessage', 'Y')";
    $results = $conn->query($sql);
		$sql = "INSERT INTO `livehelp_questions` VALUES (2, 1, 0, 'Question:', 'textarea', '', '', 'leavemessage', 'N')";
    $results = $conn->query($sql);
		$sql = "INSERT INTO `livehelp_questions` VALUES (3, 1, 0, 'Name', 'username', '', '', 'livehelp', 'N')";
    $results = $conn->query($sql);
	//	$sql = "INSERT INTO `livehelp_questions` VALUES (4, 1, 1, 'E-mail', 'email', '', '', 'livehelp', 'N')";
  //  $results = $conn->query($sql);
    $sql = "INSERT INTO `livehelp_questions` VALUES (5, 1, 1, 'Question', 'textarea', '', '', 'livehelp', 'N')";
    $results = $conn->query($sql);
    $sql = "UPDATE livehelp_departments set website='1',leavetxt='<h3><SPAN CLASS=wh>LEAVE A MESSAGE:</SPAN></h3>Please type in your comments/questions in the below box <br> and provide an e-mail address so we can get back to you'";
    $results = $conn->query($sql);		 
 
      $sql = "UPDATE `livehelp_departments` SET theme='vanilla',topframeheight=75,botbackground='themes/vanilla/patch.png',midbackground='themes/vanilla/softyellowomi.png',topbackcolor='#FFFFFF',midbackcolor='#FFFFDD',botbackcolor='#FFFFFF',colorscheme='white'";
    $results = $conn->query($sql); 

  
      $sql = "INSERT INTO `livehelp_layerinvites` (`layerid`, `name`, `imagename`, `imagemap`, `department`, `user`) VALUES
(1, '', 'layer-Man_invite.gif', '<MAP NAME=myimagemap><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,0,400,197><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,157,213,257><AREA HREF=javascript:closeDHTML() SHAPE=RECT COORDS=237,157,400,257></MAP>', '', 0),
(2, '', 'layer-Phone.gif', '<MAP NAME=myimagemap><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,0,472,150><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=241,150,484,256><AREA HREF=javascript:closeDHTML() SHAPE=RECT COORDS=0,150,241,250></MAP>', '', 0),
(3, '', 'layer-Help_button.gif', '<MAP NAME=myimagemap><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,0,400,197><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,157,213,257><AREA HREF=javascript:closeDHTML() SHAPE=RECT COORDS=237,157,400,257></MAP>', '', 0),
(4, '', 'layer-Woman_invite.png', '<MAP NAME=myimagemap><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=126,71,429,172><AREA HREF=javascript:closeDHTML() SHAPE=RECT COORDS=311,5,440,45></MAP>', '', 0),
(5, '', 'layer-Subsilver.gif', '<MAP NAME=myimagemap><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,0,419,216><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,216,319,279><AREA HREF=javascript:closeDHTML() SHAPE=RECT COORDS=326,218,429,280></MAP>', '', 0)";
    $results = $conn->query($sql); 
  
    // default website:
   $sql = " INSERT INTO  `livehelp_websites` (`id` ,`site_name` ,`site_url` ,`defaultdepartment`) VALUES ('1', 'Your Website', '" . $UNTRUSTED['homepage'] . "', '1')";
   $results = $conn->query($sql); 
   
       } // END : if($errors == "")
 } // END: $UNTRUSTED['dbtype_setup'] == "mysql"
} else {

     $missingfields = 1;

   if($installationtype == "upgrade22"){
     $sql = "ALTER TABLE `livehelp_config` ADD `speaklanguage` VARCHAR(60) DEFAULT 'English' NOT NULL ";
     $results = $conn->query($sql);
     $sql = "UPDATE livehelp_users set onchannel=user_id where isadmin='Y'";	
     $results = $conn->query($sql);
     $installationtype = "upgrade24";
   }

   if($installationtype == "upgrade24"){
     $sql = "UPDATE livehelp_config set speaklanguage='English',version='$version'";
     $results = $conn->query($sql);
     $sql = "UPDATE livehelp_users set onchannel=user_id where isadmin='Y'";	
     $results = $conn->query($sql);
     $installationtype = "upgrade25";
   }

   if($installationtype == "upgrade25"){
 
       $sql = "ALTER TABLE livehelp_users ADD auto_invite CHAR(1) NOT NULL ";
       $results = $conn->query($sql);

       $sql = "ALTER TABLE livehelp_users ADD istyping CHAR(1) NOT NULL  default '3' ";
       $results = $conn->query($sql);

       $sql = "ALTER TABLE livehelp_users ADD visits INT(8) NOT NULL ";
       $results = $conn->query($sql);
	
       $sql = "DROP TABLE IF EXISTS livehelp_modules_dep";
       $results = $conn->query($sql);
       $sql = 
       "CREATE TABLE livehelp_modules_dep (
         rec int(10) NOT NULL auto_increment,
         departmentid int(10) NOT NULL default '0',
         modid int(10) NOT NULL default '0',
         ordernum int(8) NOT NULL default '0',
         isactive char(1) NOT NULL default 'N'
         defaultset char(1) NOT NULL default '',
         PRIMARY KEY  (rec)
       )ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1; 
       ";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}

       $sql = "DROP TABLE IF EXISTS livehelp_autoinvite";
       $results = $conn->query($sql);
       $sql = 
       "CREATE TABLE `livehelp_autoinvite` (
         `idnum` int(10) NOT NULL auto_increment,
         `offline` INT(1) NOT NULL DEFAULT '0',
          isactive char(1) NOT NULL default '',  
         `department` int(10) NOT NULL default '0',
         `message` text NULL,
         `page` varchar(255) NOT NULL default '',
         `visits` int(8) NOT NULL default '0',
         `referer` varchar(255) NOT NULL default '',
         `typeof` varchar(30) NOT NULL default '',     
         `seconds` int(11) unsigned NOT NULL default '15',
          PRIMARY KEY  (idnum)
        )ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1; ";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}

       $sql = "DROP TABLE IF EXISTS livehelp_modules";
       $results = $conn->query($sql);
       $sql = 
       "CREATE TABLE livehelp_modules (
         id int(10) NOT NULL auto_increment,
         name varchar(30) NOT NULL default '',
         path varchar(255) NOT NULL default '',
         adminpath varchar(255) NOT NULL default '',
         query_string varchar(255) NOT NULL default '',  
         PRIMARY KEY  (id)
       )ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
       ";
 		
		if ( ($results = $conn->query($sql))===false ) 
		{
			echo "<H2>Query went bad: $sql</H2>\n";
			echo mysqli_errno().":  ".mysqli_error()."<P>";
			$wentwrong = true;
		}
		

		
       $sql2 = "INSERT INTO `livehelp_modules` (id,name,path) VALUES (1, 'Live Help!', 'livehelp.php')";
		$conn->query($sql2);
       $sql2 = "INSERT INTO `livehelp_modules` (id,name,path) VALUES (2, 'Contact', 'leavemessage.php')";
      		$conn->query($sql2);
       $sql2 = "INSERT INTO `livehelp_modules` (id,name,path,adminpath) VALUES (3, 'Q & A', 'user_qa.php','qa.php')";
      		$conn->query($sql2);
       $sql2 = "INSERT INTO `livehelp_modules_dep` VALUES (1, 1, 1, 1, 'N', '')";
       		$conn->query($sql2);
       $sql2 = "INSERT INTO `livehelp_modules_dep` VALUES (2, 1, 2, 2, 'N', 'Y')";
 		$conn->query($sql2);
 
      
      $installationtype = "upgrade26";
  }

    if($installationtype == "upgrade26"){
       $sql = "UPDATE livehelp_config set speaklanguage='English',version='$version'";
       $results = $conn->query($sql);
       $installationtype = "upgrade27";
     }

     if($installationtype == "upgrade27"){
        $sql = "ALTER TABLE `livehelp_config` CHANGE `version` `version` VARCHAR( 10 ) DEFAULT '$version' NOT NULL ";
        $results = $conn->query($sql);
        $installationtype = "upgrade271";
     }

     if( ($installationtype == "upgrade271") || 
         ($installationtype == "upgrade272") || 
         ($installationtype == "upgrade273") ||         
         ($installationtype == "upgrade274") ){


         $sql = "ALTER TABLE `livehelp_departments` ADD `layerinvite` VARCHAR( 255 ) NOT NULL";
         $results = $conn->query($sql);       
                  
         $sql = "ALTER TABLE `livehelp_config` ADD `s_webpath` VARCHAR(255) NOT NULL ";
         $results = $conn->query($sql);

         $sql = "ALTER TABLE `livehelp_config` ADD `scratch_space` TEXT NULL ";
         $results = $conn->query($sql);

        $sql = "ALTER TABLE `livehelp_users` ADD `jsrn` INT(5) NOT NULL ";
         $results = $conn->query($sql);
  
        $sql = "ALTER TABLE `livehelp_messages` ADD `typeof` VARCHAR(30) NOT NULL ";
         $results = $conn->query($sql);                                      
     
         // select out all of the online and offline images and remove the path 
         // to the live help (this is taken care of by webpath and s_webpath now.
         $sql = "SELECT * FROM livehelp_departments";
         $result = $results = $conn->query($sql);
         while ($row = mysqli_fetch_array($result,MYSQLI_ASSOC)) {
             $onlineimage = str_replace($UNTRUSTED['homepage'],"",$row['onlineimage']);
             $offlineimage = str_replace($UNTRUSTED['homepage'],"",$row['offlineimage']);
             $layerinvite = str_replace($UNTRUSTED['homepage'],"",$row['layerinvite']);
             $recno = $row['recno'];
             $sql = "UPDATE livehelp_departments set onlineimage='".filter_sql($onlineimage)."',offlineimage='".filter_sql($offlineimage)."',layerinvite='".filter_sql($layerinvite)."' WHERE recno=".intval($recno);
             $results = $conn->query($sql);
         }          

        $installationtype = "upgrade280";
     }

     if( ($installationtype == "upgrade280") || 
         ($installationtype == "upgrade281")
        ){         	
        
        $sql = "ALTER TABLE `livehelp_users` ADD `hostname` VARCHAR( 255 ) NOT NULL ,ADD `useragent` VARCHAR( 255 ) NOT NULL ,ADD `ipaddress` VARCHAR( 255 ) NOT NULL ;";
        $results = $conn->query($sql);      

        $scratch = "
          Welcome to CRAFTY SYNTAX Live Help 
 
All the administrative functions are located to the left of this text. 
 
You can use this section to keep notes for yourself and other admins, etc.  

To change the text that is located in this box just click on the small 
edit button on the top right corner of this box. 

        ";
        $sql = "UPDATE livehelp_config set scratch_space='$scratch'";
        $results = $conn->query($sql);
        
        $installationtype = "upgrade282";
     }
     
if( ($installationtype == "upgrade282") ){ 
	 
     $sql = "ALTER TABLE `livehelp_referers` ADD `parentrec` INT( 10 ) NOT NULL";
     $results = $conn->query($sql);

     $sql = "ALTER TABLE `livehelp_referers_total` ADD `dateof` INT( 7 ) NOT NULL";
     $results = $conn->query($sql);
     
     $sql = "ALTER TABLE `livehelp_referers_total` ADD `parentrec` INT( 10 ) NOT NULL";
     $results = $conn->query($sql);

     $sql = "ALTER TABLE `livehelp_visits_total` ADD `dateof` INT( 7 ) NOT NULL";
     $results = $conn->query($sql);
          
     $sql = "ALTER TABLE `livehelp_config` ADD `admin_refresh` VARCHAR(30) NOT NULL";
     $results = $conn->query($sql);

     $sql = "ALTER TABLE `livehelp_autoinvite` ADD `typeof` VARCHAR(30) NOT NULL";
     $results = $conn->query($sql);

     $sql = "ALTER TABLE `livehelp_departments` ADD `imagemap` TEXT NULL";
     $results = $conn->query($sql);

     $sql = "ALTER TABLE `livehelp_operator_channels` ADD `txtcolor` VARCHAR( 10 ) NOT NULL";
     $results = $conn->query($sql);     

     $sql = "ALTER TABLE `livehelp_operator_channels` ADD `channelcolor` VARCHAR( 10 ) NOT NULL";
     $results = $conn->query($sql);  
                         
     $sql = "UPDATE livehelp_departments set creditline='L',imagemap='<MAP NAME=myimagemap><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,0,400,197><AREA HREF=javascript:openLiveHelp() SHAPE=RECT COORDS=0,157,213,257><AREA HREF=javascript:closeDHTML() SHAPE=RECT COORDS=237,157,400,257></MAP>'";
     $results = $conn->query($sql);

$installationtype = "upgrade284";
}

if( ($installationtype == "upgrade284") ){                                 
     $sql = "ALTER TABLE `livehelp_departments` ADD `whilewait` TEXT NULL";
     $results = $conn->query($sql);
     
     $sql = "ALTER TABLE `livehelp_quick` ADD `ishtml` VARCHAR( 3 ) NOT NULL ";
     $results = $conn->query($sql);

     $sql = "ALTER TABLE `livehelp_users` ADD `sessionid` VARCHAR( 40 ) NOT NULL ";
     $results = $conn->query($sql);

     $sql = "ALTER TABLE `livehelp_users` ADD `sessiondata` TEXT NULL ";
     $results = $conn->query($sql);
     
     $sql = "ALTER TABLE `livehelp_users` ADD `cookied` CHAR( 1 ) DEFAULT 'N' NOT NULL";
     $results = $conn->query($sql);
     
     $sql = "ALTER TABLE `livehelp_users` ADD `expires` bigint(14) NOT NULL";
     $results = $conn->query($sql);
          
     $sql = "ALTER TABLE `livehelp_users` ADD `authenticated` CHAR(1) NOT NULL ";
     $results = $conn->query($sql);

    $sql = "ALTER TABLE `livehelp_departments` ADD `timeout` INT( 4 ) NOT NULL";
    $results = $conn->query($sql);

    $sql = "UPDATE `livehelp_departments` SET `timeout`=150";
    $results = $conn->query($sql);
      
    $sql = "ALTER TABLE `livehelp_transcripts` ADD `sessionid` VARCHAR( 40 ) NOT NULL , ADD `sessiondata` TEXT NULL , ADD `department` INT( 10 ) NOT NULL ";
    $results = $conn->query($sql);      
      
    $sql = "
      CREATE TABLE `livehelp_questions` (
      `id` INT( 10 ) NOT NULL AUTO_INCREMENT ,
      `department` INT( 10 ) NOT NULL  default '0',
      `ordering` INT( 8 ) NOT NULL default '0',
      `headertext` TEXT NULL,
      `fieldtype` VARCHAR( 30 ) NOT NULL default '0',
      `options` TEXT NULL,
      `flags` VARCHAR( 60 ) NOT NULL default '',
      `module` VARCHAR( 60 ) NOT NULL default '',
      `required` CHAR( 1 ) DEFAULT 'N' NOT NULL,
      PRIMARY KEY ( `id` ) ,
      INDEX ( `department` ) 
      )ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
    ";
    $results = $conn->query($sql);
          
    $sql = 
       "CREATE TABLE `livehelp_smilies` (
        `smilies_id` smallint(5) unsigned NOT NULL auto_increment,
        `code` varchar(50) default NULL,
        `smile_url` varchar(100) default NULL,
        `emoticon` varchar(75) default NULL,
        PRIMARY KEY  (`smilies_id`)
       ) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
       ";
 		   $conn->query($sql);
 		   
 		$sql = "INSERT INTO `livehelp_smilies` VALUES (1, ':D', 'icon_biggrin.gif', 'Very Happy')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (2, ':-D', 'icon_biggrin.gif', 'Very Happy')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (3, ':grin:', 'icon_biggrin.gif', 'Very Happy')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (4, ':)', 'icon_smile.gif', 'Smile')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (5, ':-)', 'icon_smile.gif', 'Smile')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (6, ':smile:', 'icon_smile.gif', 'Smile')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (7, ':(', 'icon_sad.gif', 'Sad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (8, ':-(', 'icon_sad.gif', 'Sad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (9, ':sad:', 'icon_sad.gif', 'Sad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (10, ':o', 'icon_surprised.gif', 'Surprised')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (11, ':-o', 'icon_surprised.gif', 'Surprised')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (12, ':eek:', 'icon_surprised.gif', 'Surprised')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (13, ':shock:', 'icon_eek.gif', 'Shocked')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (14, ':?', 'icon_confused.gif', 'Confused')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (15, ':-?', 'icon_confused.gif', 'Confused')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (16, ':???:', 'icon_confused.gif', 'Confused')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (17, '8)', 'icon_cool.gif', 'Cool')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (18, '8-)', 'icon_cool.gif', 'Cool')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (19, ':cool:', 'icon_cool.gif', 'Cool')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (20, ':lol:', 'icon_lol.gif', 'Laughing')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (21, ':x', 'icon_mad.gif', 'Mad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (22, ':-x', 'icon_mad.gif', 'Mad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (23, ':mad:', 'icon_mad.gif', 'Mad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (24, ':P', 'icon_razz.gif', 'Razz')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (25, ':-P', 'icon_razz.gif', 'Razz')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (26, ':razz:', 'icon_razz.gif', 'Razz')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (27, ':oops:', 'icon_redface.gif', 'Embarassed')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (28, ':cry:', 'icon_cry.gif', 'Crying or Very sad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (29, ':evil:', 'icon_evil.gif', 'Evil or Very Mad')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (30, ':twisted:', 'icon_twisted.gif', 'Twisted Evil')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (31, ':roll:', 'icon_rolleyes.gif', 'Rolling Eyes')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (32, ':wink:', 'icon_wink.gif', 'Wink')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (33, ';)', 'icon_wink.gif', 'Wink')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (34, ';-)', 'icon_wink.gif', 'Wink')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (35, ':!:', 'icon_exclaim.gif', 'Exclamation')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (36, ':?:', 'icon_question.gif', 'Question')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (37, ':idea:', 'icon_idea.gif', 'Idea')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (38, ':arrow:', 'icon_arrow.gif', 'Arrow')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (39, ':|', 'icon_neutral.gif', 'Neutral')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (40, ':-|', 'icon_neutral.gif', 'Neutral')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (41, ':neutral:', 'icon_neutral.gif', 'Neutral')";
 		$conn->query($sql);
$sql = "INSERT INTO  `livehelp_smilies` VALUES (42, ':mrgreen:', 'icon_mrgreen.gif', 'Mr. Green')";
 		$conn->query($sql);
     		          
     
        $scratch = "
           Welcome to CRAFTY SYNTAX Live Help 

All the administrative functions are located to the left of this text. 
 
You can use this section to keep notes for yourself and other admins, etc. 
 
To change the text that is located in this box just click on the small 
edit button on the top right corner of this box. 
 
        ";
        $sql = "UPDATE livehelp_config set scratch_space='$scratch'";
$conn->query($sql);
$installationtype = "upgrade290";
}
if( ($installationtype == "upgrade290") ){ 
	 
	  $sql = "ALTER TABLE `livehelp_config` CHANGE `speaklanguage` `speaklanguage` VARCHAR( 60 ) DEFAULT 'English' NOT NULL";
	  $results = $conn->query($sql);
    
    $sql = "ALTER TABLE `livehelp_departments` ADD `leavetxt` TEXT NULL";
    $results = $conn->query($sql);               

    $sql = "UPDATE livehelp_departments set leavetxt='<h3><SPAN CLASS=wh>LEAVE A MESSAGE:</SPAN></h3>Please type in your comments/questions in the below box <br> and provide an e-mail address so we can get back to you'";
    $results = $conn->query($sql);    
    
$installationtype = "upgrade291";
}
if( ($installationtype == "upgrade291") || ($installationtype == "upgrade292") ){ 

 
    $sql = "ALTER TABLE `livehelp_users` ADD `greeting` TEXT NULL";
    $results = $conn->query($sql); 
    
    $sql = "ALTER TABLE `livehelp_users` ADD `photo` VARCHAR( 255 ) NOT NULL";
    $results = $conn->query($sql); 
    
    $sql = "UPDATE `livehelp_users` set `greeting`='How may I help You?',photo=''";
    $results = $conn->query($sql); 

$installationtype = "upgrade293"; 
}

if($installationtype == "upgrade293") {
	
	 $sql = "ALTER TABLE `livehelp_users` ADD `chataction` BIGINT( 14 ) NOT NULL";
	 $results = $conn->query($sql);
	 $sql = "ALTER TABLE `livehelp_config` ADD PRIMARY KEY ( `version` )";
	 $results = $conn->query($sql);
	 
$installationtype = "upgrade294"; 
} 

if( ($installationtype == "upgrade294") || ($installationtype == "upgrade295") ){

   $sql = "ALTER TABLE `livehelp_users` ADD `new_session` CHAR( 1 ) DEFAULT 'Y' NOT NULL";
   $results = $conn->query($sql);
$installationtype = "upgrade296"; 
}

if($installationtype == "upgrade296"){
   $sql = "ALTER TABLE `livehelp_users` ADD `showtype` INT( 10 ) DEFAULT '1' NOT NULL";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_config` ADD `maxexe` int(5) DEFAULT '180'";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_transcripts` CHANGE `daytime` `daytime` BIGINT( 14 ) DEFAULT NULL";
   $results = $conn->query($sql);      	
   $sql = "ALTER TABLE `livehelp_visit_track` CHANGE `whendone` `whendone` BIGINT(14) DEFAULT NULL"; 
   $results = $conn->query($sql);  
   $sql = "ALTER TABLE `livehelp_config` ADD `refreshrate` INT(4) DEFAULT '1' NOT NULL";
   $results = $conn->query($sql);    
   $sql = "UPDATE livehelp_config set admin_refresh='auto',membernum='0',speaklanguage='English',version='$version'";
   $results = $conn->query($sql);
   
   $installationtype = "upgrade297";    
}
if($installationtype == "upgrade297"){


   $sql = "ALTER TABLE `livehelp_departments` ADD `topframeheight` INT( 10 ) DEFAULT '85' NOT NULL";
   $results = $conn->query($sql);   
   $sql = "ALTER TABLE `livehelp_departments` ADD `topbackground` VARCHAR( 255 ) NOT NULL default 'header_images/customersupports.png'";
   $results = $conn->query($sql);   
   $sql = "ALTER TABLE `livehelp_departments` ADD `colorscheme` VARCHAR( 255 ) NOT NULL default 'white'";
   $results = $conn->query($sql);   
   $sql = "ALTER TABLE `livehelp_transcripts` ADD `email` VARCHAR( 60 ) NOT NULL default ''";
   $results = $conn->query($sql);   
   $sql = "UPDATE livehelp_departments set topframeheight='85',topbackground='header_images/customersupports.png',colorscheme='white'";
   $results = $conn->query($sql);   
   $installationtype = "upgrade298";   
 }
   
if( ($installationtype == "upgrade298") || ($installationtype == "upgrade299") ){
   $sql = "ALTER TABLE `livehelp_config` ADD `chatmode` VARCHAR( 60 ) NOT NULL";
   $results = $conn->query($sql);   

   $sql = "ALTER TABLE `livehelp_config` ADD `adminsession` CHAR( 1 ) DEFAULT 'Y' NOT NULL";
   $results = $conn->query($sql);  

   $sql = "ALTER TABLE `livehelp_users` ADD `chattype` CHAR( 1 ) DEFAULT 'Y' NOT NULL";
   $results = $conn->query($sql);
   
   $sql = "ALTER TABLE `livehelp_users` ADD `externalchats` VARCHAR( 255 ) DEFAULT '' NOT NULL";
   $results = $conn->query($sql);

   $sql = "ALTER TABLE `livehelp_operator_channels` ADD `txtcolor_alt` VARCHAR( 10 ) NOT NULL";
   $results = $conn->query($sql);      

        $scratch = "
        
  Welcome to CRAFTY SYNTAX Live Help 
  
All the administrative functions are located to the left of this text. 
 
You can use this section to keep notes for yourself and other admins, etc.
 
To change the text that is located in this box just click on the small 
edit button on the top right corner of this box. 
 
        ";
        $sql = "UPDATE livehelp_config set scratch_space='$scratch'";
        $results = $conn->query($sql);
        
  $installationtype = "upgrade2100";
}   

if($installationtype == "upgrade2100"){

   $sql = "ALTER TABLE `livehelp_quick` CHANGE `department` `department` VARCHAR( 60 ) DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);        
   
   $installationtype = "upgrade2101";
  }
  
if($installationtype == "upgrade2101"){  

    $sql = "
CREATE TABLE `livehelp_operator_history` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `opid` int(11) unsigned NOT NULL default '0',
  `action` varchar(60) NOT NULL default '',
  `dateof` bigint(14) NOT NULL default '0',
  `sessionid` varchar(40) NOT NULL default '',
  `transcriptid` int(10) NOT NULL default '0',
  `totaltime` int(10) NOT NULL default '0',
  `channel` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  INDEX ( `opid` ), 
  INDEX ( `dateof` )   
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
    ";
    $results = $conn->query($sql);
   
   $sql = "ALTER TABLE `livehelp_departments` ADD `speaklanguage` VARCHAR( 60 ) NOT NULL";
   $results = $conn->query($sql);

   $sql = "ALTER TABLE `livehelp_departments` ADD `busymess` TEXT NULL";
   $results = $conn->query($sql);

   $sql = "ALTER TABLE `livehelp_config` ADD `ignoreips` TEXT NULL";
   $results = $conn->query($sql);   
     
   $sql = "UPDATE livehelp_departments set busymess='<blockquote>Sorry all operators are currently helping other clients and are unable to provide Live support at this time.<br>Would you like to continue to wait for an operator or leave a message?<br><table width=450><tr><td><a href=livehelp.php?page=livehelp.php?page=livehelp.php&department=[department]&tab=1 target=_top><font size=+1>Continue to wait</font></a></td><td align=center><b>or</b></td><td><a href=leavemessage.php?department=[department]><font size=+1>Leave a message</a></td></tr></table><blockquote>'";
   $results = $conn->query($sql);
         
   $installationtype = "upgrade2102";
  }
  
 
if( ($installationtype == "upgrade2103") || ($installationtype == "upgrade2102") ){ 
 
   $sql = "ALTER TABLE `livehelp_config` ADD `directoryid` VARCHAR( 32 ) NOT NULL";
   $results = $conn->query($sql); 

   $sql = "ALTER TABLE `livehelp_config` ADD `tracking` CHAR( 1 ) DEFAULT 'N' NOT NULL";
   $results = $conn->query($sql); 

   $sql = "ALTER TABLE `livehelp_config` ADD `colorscheme` VARCHAR( 30 ) DEFAULT 'white' NOT NULL";
   $results = $conn->query($sql); 

   $sql = "ALTER TABLE `livehelp_users` ADD `layerinvite` INT( 10 ) DEFAULT '0' NOT NULL";
   $results = $conn->query($sql); 
   
    $sql = "
    CREATE TABLE `livehelp_layerinvites` (
  `layerid` int(10) NOT NULL default '0',
  `name` varchar(60) NOT NULL default '',
  `imagename` varchar(60) NOT NULL default '',
  `imagemap` text NULL,
  `department` varchar(60) NOT NULL default '',
  `user` int(10) NOT NULL default '0',
  PRIMARY KEY  (`layerid`)
   ) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql); 

   $installationtype = "upgrade2104";
}

if($installationtype == "upgrade2104"){
	 
	 // auto invites are now in the database by id number but is is only 1 to 99:
   for($i=0;$i<26;$i++){
   	 $j= $i+100;
  	 $sql = "UPDATE livehelp_autoinvite SET message='$i' WHERE message='$j'";
	   $results = $conn->query($sql);
 	 } 
	    
   $installationtype = "upgrade2105";
}

if($installationtype == "upgrade2105"){
	 
	 //turn off max execution timeout .. this might take 45 seconds or 
	 // more to do it the tables are big:
  @ini_set("max_execution_time",0);

	 // most of the data inside livehelp_visit_track is orphaned data
	 // and is the cause of most of the performance issues in 2.10.x
	 // this optimizes the tables after truncate:
	 $sql = "TRUNCATE livehelp_visit_track";
	 $results = $conn->query($sql); 	    
	 $sql = "ALTER TABLE `livehelp_visit_track` CHANGE `location` `location` VARCHAR( 255 ) NOT NULL";
   $results = $conn->query($sql);       
   $sql = "ALTER TABLE `livehelp_visit_track` CHANGE `id` `sessionid` VARCHAR( 40 ) DEFAULT '0' NOT NULL"; 
   $results = $conn->query($sql);             
   $sql = "ALTER TABLE `livehelp_visit_track` ADD INDEX ( `location` )";
   $results = $conn->query($sql);                
   $sql = "ALTER TABLE `livehelp_visit_track` ADD INDEX ( `whendone` )"; 
   $results = $conn->query($sql);    
   $sql = "ALTER TABLE `livehelp_visit_track` CHANGE `referrer` `referrer` VARCHAR( 255 ) NOT NULL";
   $results = $conn->query($sql);    
   
   $sql = "ALTER TABLE `livehelp_channels` ADD `sessionid` VARCHAR( 40 ) NOT NULL";
   $results = $conn->query($sql);    
 
   $sql = "ALTER TABLE `livehelp_users` CHANGE `camefrom` `camefrom` VARCHAR( 255 ) NOT NULL";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_users` ADD `askquestions` CHAR( 1 ) DEFAULT 'Y' NOT NULL";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_users` ADD `showvisitors` CHAR( 1 ) DEFAULT 'N' NOT NULL";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_users` CHANGE `showedup` `showedup` BIGINT( 14 ) DEFAULT '0' NOT NULL";
   $results = $conn->query($sql); 
 
   $sql = "ALTER TABLE `livehelp_operator_history` ADD INDEX ( `opid` )";
   $results = $conn->query($sql);      
   $sql = "ALTER TABLE `livehelp_operator_history` ADD INDEX ( `dateof` )"; 
   $results = $conn->query($sql);                  

	 $sql = "ALTER TABLE `livehelp_config` ADD `matchip` CHAR(1) DEFAULT 'N' NOT NULL";
   $results = $conn->query($sql); 
	 $sql = "ALTER TABLE `livehelp_config` ADD `gethostnames` CHAR(1) DEFAULT 'N' NOT NULL";
   $results = $conn->query($sql); 
	 $sql = "ALTER TABLE `livehelp_config` ADD `maxreferers` INT( 10 ) DEFAULT '50' NOT NULL";
   $results = $conn->query($sql); 
	 $sql = "ALTER TABLE `livehelp_config` ADD `maxvisits` INT( 10 ) DEFAULT '100' NOT NULL";
   $results = $conn->query($sql);  
	 $sql = "ALTER TABLE `livehelp_config` ADD `maxmonths` INT( 10 ) DEFAULT '12' NOT NULL";
   $results = $conn->query($sql);    
	 $sql = "ALTER TABLE `livehelp_config` ADD `maxoldhits` INT( 10 ) NOT NULL";
   $results = $conn->query($sql);  
	 $sql = "ALTER TABLE `livehelp_config` ADD `maxrecords` INT( 10 ) NOT NULL";
   $results = $conn->query($sql);                
	 $sql = "ALTER TABLE `livehelp_config` ADD `showgames` CHAR(1) NOT NULL";
   $results = $conn->query($sql);   
	 $sql = "ALTER TABLE `livehelp_config` ADD `showsearch` CHAR(1) NOT NULL";
   $results = $conn->query($sql); 
	 $sql = "ALTER TABLE `livehelp_config` ADD `showdirectory` CHAR(1) NOT NULL";
   $results = $conn->query($sql); 
 
   $sql = "ALTER TABLE `livehelp_referers` RENAME `livehelp_referers_daily`";
   $results = $conn->query($sql);      
   $sql = "ALTER TABLE `livehelp_referers_daily` DROP INDEX `uniquevisits`";
   $results = $conn->query($sql);    
   $sql = "ALTER TABLE `livehelp_referers_daily` DROP INDEX `camefrom`";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_daily` DROP INDEX `dayof`";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_daily` CHANGE `camefrom` `pageurl` VARCHAR( 255 ) DEFAULT '' NOT NULL";    
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_daily` CHANGE `dayof` `dateof` INT( 8 ) DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);         
   $sql = "ALTER TABLE `livehelp_referers_daily` CHANGE `uniquevisits` `levelvisits` int(11) unsigned NOT NULL default '0'";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_daily` ADD `directvisits` INT( 11 ) UNSIGNED DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_daily` ADD `level` INT( 10 ) DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_daily` ADD INDEX ( `pageurl` )";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_daily` ADD INDEX ( `parentrec` )";
   $results = $conn->query($sql);      
   $sql = "ALTER TABLE `livehelp_referers_daily` ADD INDEX ( `levelvisits` )";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_referers_daily` ADD INDEX ( `directvisits` )";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_referers_daily` ADD INDEX ( `dateof` )";
   $results = $conn->query($sql);       
   
                           
   $sql = "ALTER TABLE `livehelp_referers_total` RENAME `livehelp_referers_monthly`";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_referers_monthly` DROP INDEX `ctotal`";
   $results = $conn->query($sql);    
   $sql = "ALTER TABLE `livehelp_referers_monthly` DROP INDEX `camefrom`";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_monthly` CHANGE `camefrom` `pageurl` VARCHAR( 255 ) DEFAULT '' NOT NULL";    
   $results = $conn->query($sql);       
   $sql = "ALTER TABLE `livehelp_referers_monthly` CHANGE `ctotal` `levelvisits` int(11) unsigned NOT NULL default '0'";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_monthly` ADD `directvisits` INT( 11 ) UNSIGNED DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_monthly` ADD `level` INT( 10 ) DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_referers_monthly` ADD INDEX ( `pageurl` )";
   $results = $conn->query($sql);     
   $sql = "ALTER TABLE `livehelp_referers_monthly` ADD INDEX ( `levelvisits` )";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_referers_monthly` ADD INDEX ( `directvisits` )";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_referers_monthly` ADD INDEX ( `dateof` )";
   $results = $conn->query($sql);     
   
   $sql = "ALTER TABLE `livehelp_visits` RENAME `livehelp_visits_daily`";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_visits_daily` DROP INDEX `uniquevisits`";
   $results = $conn->query($sql);    
   $sql = "ALTER TABLE `livehelp_visits_daily` DROP INDEX `dayof`";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_visits_daily` CHANGE `dayof` `dateof` INT( 8 ) DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);         
   $sql = "ALTER TABLE `livehelp_visits_daily` CHANGE `uniquevisits` `directvisits` int(11) unsigned NOT NULL default '0'";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_visits_daily` ADD `levelvisits` INT( 11 ) UNSIGNED DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_visits_daily` ADD `parentrec` INT( 11 ) UNSIGNED DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);
   $sql = "UPDATE `livehelp_visits_daily` SET `levelvisits`=`directvisits`";
   $results = $conn->query($sql);   
   $sql = "ALTER TABLE `livehelp_visits_daily` ADD `level` INT( 10 ) DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_visits_daily` ADD INDEX ( `pageurl` )";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_visits_daily` ADD INDEX ( `parentrec` )";
   $results = $conn->query($sql);      
   $sql = "ALTER TABLE `livehelp_visits_daily` ADD INDEX ( `levelvisits` )";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_visits_daily` ADD INDEX ( `directvisits` )";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_visits_daily` ADD INDEX ( `dateof` )";
   $results = $conn->query($sql); 

   $sql = "ALTER TABLE `livehelp_visits_total` RENAME `livehelp_visits_monthly`";
   $results = $conn->query($sql);          
   $sql = "ALTER TABLE `livehelp_visits_monthly` DROP INDEX `ctotal`";
   $results = $conn->query($sql);          
   $sql = "ALTER TABLE `livehelp_visits_monthly` CHANGE `ctotal` `directvisits` int(11) unsigned NOT NULL default '0'";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_visits_monthly` ADD `levelvisits` INT( 11 ) UNSIGNED DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);
   $sql = "UPDATE `livehelp_visits_monthly` SET `levelvisits`=`directvisits`";
   $results = $conn->query($sql);  
   $sql = "ALTER TABLE `livehelp_visits_monthly` ADD `level` INT( 10 ) DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);
   $sql = "ALTER TABLE `livehelp_visits_monthly` ADD `parentrec` INT( 11 ) UNSIGNED DEFAULT '0' NOT NULL";
   $results = $conn->query($sql);   
   $sql = "ALTER TABLE `livehelp_visits_monthly` ADD INDEX ( `parentrec` )";
   $results = $conn->query($sql);      
   $sql = "ALTER TABLE `livehelp_visits_monthly` ADD INDEX ( `pageurl` )";
   $results = $conn->query($sql);     
   $sql = "ALTER TABLE `livehelp_visits_monthly` ADD INDEX ( `levelvisits` )";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_visits_monthly` ADD INDEX ( `directvisits` )";
   $results = $conn->query($sql); 
   $sql = "ALTER TABLE `livehelp_visits_monthly` ADD INDEX ( `dateof` )";
   $results = $conn->query($sql);   
            
   $installationtype = "upgrade2111";
  }   
  
if( ($installationtype == "upgrade2110") || ($installationtype == "upgrade2111")){  
	
    $sql = "DROP TABLE IF EXISTS livehelp_referers";
    $results = $conn->query($sql);		
 
    $sql = "DROP TABLE IF EXISTS livehelp_referers_total";
    $results = $conn->query($sql);	

    $sql = "DROP TABLE IF EXISTS livehelp_visits";
    $results = $conn->query($sql);
 
    $sql = "DROP TABLE IF EXISTS livehelp_visits_total";
    $results = $conn->query($sql);
    
    $sql = "ALTER TABLE `livehelp_config` ADD `usertracking` CHAR( 1 ) DEFAULT 'N' NOT NULL ";
    $results = $conn->query($sql);

    $sql = "ALTER TABLE `livehelp_config` ADD `resetbutton` CHAR( 1 ) DEFAULT 'N' NOT NULL ";
    $results = $conn->query($sql);
    
    $sql = "ALTER TABLE `livehelp_users` ADD `cookieid` VARCHAR( 40 ) NOT NULL";
    $results = $conn->query($sql);
    
    $sql = "CREATE TABLE `livehelp_identity_daily` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `isnamed` char(1) NOT NULL default 'N',
  `groupidentity` int(11) NOT NULL default '0',
  `groupusername` int(11) NOT NULL default '0',
  `identity` varchar(100) NOT NULL default '',
  `cookieid` varchar(40) NOT NULL default '',
  `ipaddress` varchar(30) NOT NULL default '',
  `username` varchar(100) NOT NULL default '',
  `dateof` bigint(14) NOT NULL default '0',
  `uservisits` int(10) NOT NULL default '0',
  `seconds` int(10) NOT NULL default '0',
  `useragent` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `isnamed` (`isnamed`),
  KEY `groupidentity` (`groupidentity`),
  KEY `groupusername` (`groupusername`),
  KEY `identity` (`identity`),
  KEY `cookieid` (`cookieid`),
  KEY `username` (`username`),
  KEY `dateof` (`dateof`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
    $results = $conn->query($sql);


    $sql = "CREATE TABLE `livehelp_identity_monthly` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `isnamed` char(1) NOT NULL default 'N',
  `groupidentity` int(11) NOT NULL default '0',
  `groupusername` int(11) NOT NULL default '0',
  `identity` varchar(100) NOT NULL default '',
  `cookieid` varchar(40) NOT NULL default '',
  `ipaddress` varchar(30) NOT NULL default '',
  `username` varchar(100) NOT NULL default '',
  `dateof` bigint(14) NOT NULL default '0',
  `uservisits` int(10) NOT NULL default '0',
  `seconds` int(10) NOT NULL default '0',
  `useragent` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `isnamed` (`isnamed`),
  KEY `groupidentity` (`groupidentity`),
  KEY `groupusername` (`groupusername`),
  KEY `identity` (`identity`),
  KEY `cookieid` (`cookieid`),
  KEY `username` (`username`),
  KEY `dateof` (`dateof`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
    $results = $conn->query($sql);
    

   $installationtype = "upgrade2112";
              	
   $sql = "UPDATE livehelp_config set showgames='Y',showsearch='Y',showdirectory='Y',maxreferers=50,maxvisits=75,maxmonths=12,maxoldhits=1,maxrecords=75000,chatmode='xmlhttp-flush-refresh',admin_refresh='auto',membernum='0',speaklanguage='English',version='$version'";
   $results = $conn->query($sql);
   
   }

if( ($installationtype == "upgrade2112") || ($installationtype == "upgrade2113") || ($installationtype == "upgrade2114") || ($installationtype == "upgrade2115") || ($installationtype == "upgrade2116") ){
   $sql = "UPDATE livehelp_config set showgames='Y',showsearch='Y',showdirectory='Y',maxreferers=50,maxvisits=75,maxmonths=12,maxoldhits=1,maxrecords=75000,chatmode='xmlhttp-flush-refresh',admin_refresh='auto',version='$version'";
   $results = $conn->query($sql);
   $installationtype = "upgrade2117";
 }
 
if($installationtype == "upgrade2117"){
	 
	  $sql = "ALTER TABLE `livehelp_departments` ADD `emailfun` CHAR( 1 ) DEFAULT 'Y' NOT NULL";
    $results = $conn->query($sql);

	  $sql = "ALTER TABLE `livehelp_departments` ADD `dbfun` CHAR( 1 ) DEFAULT 'Y' NOT NULL";
    $results = $conn->query($sql);    

	  $sql = "ALTER TABLE `livehelp_departments` ADD `everythingelse` text NULL";
    $results = $conn->query($sql);   

	  $sql = "ALTER TABLE `livehelp_config` ADD `reftracking` CHAR( 1 ) DEFAULT 'N' NOT NULL";
    $results = $conn->query($sql);   
 
 	  $sql = "ALTER TABLE `livehelp_config` ADD `keywordtrack` CHAR( 1 ) DEFAULT 'N' NOT NULL";
    $results = $conn->query($sql); 

 	  $sql = "ALTER TABLE `livehelp_config` ADD `topkeywords` int(10) DEFAULT '50' NOT NULL";
    $results = $conn->query($sql);     
 
 	  $sql = "ALTER TABLE `livehelp_config` ADD `rememberusers` CHAR( 1 ) DEFAULT 'Y' NOT NULL";
    $results = $conn->query($sql);   
  
 	  $sql = "ALTER TABLE `livehelp_config` ADD `everythingelse` text NULL";
    $results = $conn->query($sql);   
   
 	  $sql = "ALTER TABLE `livehelp_transcripts` CHANGE `daytime` `endtime` BIGINT( 14 ) DEFAULT NULL";
    $results = $conn->query($sql);   
   
 	  $sql = "ALTER TABLE `livehelp_transcripts` ADD `starttime` BIGINT( 14 ) NOT NULL";
    $results = $conn->query($sql);          
   
 	  $sql = "ALTER TABLE `livehelp_transcripts` ADD `duration` INT( 11 ) UNSIGNED NOT NULL";
    $results = $conn->query($sql);     
   
 	  $sql = "ALTER TABLE `livehelp_transcripts` ADD `operators` VARCHAR( 255 ) NOT NULL";
    $results = $conn->query($sql); 
   
 	  $sql = "UPDATE `livehelp_transcripts` SET starttime=endtime";
    $results = $conn->query($sql); 
   
 	  $sql = "UPDATE `livehelp_transcripts` SET duration=0";
    $results = $conn->query($sql); 
    
  	$sql = "
  CREATE TABLE `livehelp_leavemessage` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `email` varchar(255) NOT NULL default '',
  `subject` varchar(200) NOT NULL default '',
  `department` int(11) unsigned NOT NULL default '0',
  `dateof` bigint(14) NOT NULL default '0',
  `sessiondata` text NULL,
  `deliminated` text NULL,
  PRIMARY KEY  (`id`),
  KEY `department` (`department`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
  	";
    $results = $conn->query($sql);   
 
   	$sql = "
CREATE TABLE `livehelp_keywords_daily` (
  `recno` int(11) NOT NULL auto_increment,
  `parentrec` int(11) unsigned NOT NULL default '0',
  `referer` varchar(255) NOT NULL default '',
  `pageurl` varchar(255) NOT NULL default '',
  `keywords` varchar(255) NOT NULL default '',
  `dateof` int(8) NOT NULL default '0',
  `levelvisits` int(11) unsigned NOT NULL default '0',
  `directvisits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`recno`),
  KEY `levelvisits` (`levelvisits`),
  KEY `dateof` (`dateof`),
  KEY `referer` (`referer`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
  	";
    $results = $conn->query($sql);  
 
 
    	$sql = "
CREATE TABLE `livehelp_keywords_monthly` (
  `recno` int(11) NOT NULL auto_increment,
  `parentrec` int(11) unsigned NOT NULL default '0',
  `referer` varchar(255) NOT NULL default '',
  `pageurl` varchar(255) NOT NULL default '',
  `keywords` varchar(255) NOT NULL default '',
  `dateof` int(8) NOT NULL default '0',
  `levelvisits` int(11) unsigned NOT NULL default '0',
  `directvisits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`recno`),
  KEY `levelvisits` (`levelvisits`),
  KEY `dateof` (`dateof`),
  KEY `referer` (`referer`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
  	";
    $results = $conn->query($sql);  
	
	 $installationtype = "upgrade2120";
} 


if( ($installationtype == "upgrade2120") || ($installationtype == "upgrade2121") ){
	 $sql = "ALTER TABLE `livehelp_visit_track` ADD INDEX ( `page` )";
   $results = $conn->query($sql);	 
	
	 $sql = "UPDATE livehelp_config set version='$version'";
   $results = $conn->query($sql);
   
   $installationtype = "upgrade2122";
}
 
if( ($installationtype == "upgrade2122") || ($installationtype == "upgrade2123") ){
 
	 $sql = "ALTER TABLE `livehelp_departments` ADD `ordering` INT( 8 ) NOT NULL";
   $results = $conn->query($sql);	    
  
     $installationtype = "upgrade2124"; 
 } 

if($installationtype == "upgrade2124" ){
 
   
	 $sql = "UPDATE `livehelp_users` SET `showtype`='1'";
   $results = $conn->query($sql);	    
	 
	 $sql = "ALTER TABLE `livehelp_users` CHANGE `showtype` `showtype` INT( 10 ) DEFAULT '1' NOT NULL ";
   $results = $conn->query($sql);	

   $installationtype = "upgrade2125";
 } 

if( ($installationtype == "upgrade2125" ) || ($installationtype == "upgrade2126" ) || ($installationtype == "upgrade2127") ){           	 
 
   $sql = "CREATE TABLE `livehelp_paths_firsts` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `visit_recno` int(11) unsigned NOT NULL default '0',
  `exit_recno` int(11) unsigned NOT NULL default '0',
  `dateof` int(8) NOT NULL default '0',
  `visits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `visit_recno` (`visit_recno`,`dateof`,`visits`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql);
   
  $sql = "CREATE TABLE `livehelp_paths_monthly` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `visit_recno` int(11) unsigned NOT NULL default '0',
  `exit_recno` int(11) unsigned NOT NULL default '0',
  `dateof` int(8) NOT NULL default '0',
  `visits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `visit_recno` (`visit_recno`,`dateof`,`visits`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql);
   
  $sql = "ALTER TABLE `livehelp_departments` ADD `smiles` CHAR( 1 ) NOT NULL DEFAULT 'Y'";
  $results = $conn->query($sql);  
 
  $sql = "ALTER TABLE livehelp_autoinvite ADD seconds int(11) unsigned NOT NULL default '0'";
  $results = $conn->query($sql);     

  $installationtype = "upgrade2128";
  
  } 

 if($installationtype == "upgrade2128" ){
   	 
	 $sql = "ALTER TABLE `livehelp_departments` ADD `visible` INT( 1 ) DEFAULT '1' NOT NULL";
   $results = $conn->query($sql);	   
   
   $installationtype = "upgrade2129";
 } 
 
 if( ($installationtype == "upgrade2129" ) || ($installationtype == "upgrade2130" ) || ($installationtype == "upgrade2131" ) || ($installationtype == "upgrade2140" ) ){
  
   $sql = "CREATE TABLE `livehelp_sessions` (
  `session_id` varchar(100) NOT NULL default '',
  `session_data` text NOT NULL,
  `expires` int(11) NOT NULL default '0',
   PRIMARY KEY  (`session_id`)
   ) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
   $results = $conn->query($sql);
   
   $sql = "UPDATE livehelp_config set maxexe=180,refreshrate=1,chatmode='xmlhttp-flush-refresh',version='$version'";
   $results = $conn->query($sql);
   
   $installationtype = "upgrade2141"; 
 }    
 
  if($installationtype == "upgrade2141" ){
   	 
	 $sql = "ALTER TABLE `livehelp_config` ADD `smtp_host` VARCHAR( 255 ) NOT NULL default ''";
   $results = $conn->query($sql);	
	 $sql = "ALTER TABLE `livehelp_config` ADD `smtp_username` VARCHAR( 60 ) NOT NULL default ''";
   $results = $conn->query($sql);	
	 $sql = "ALTER TABLE `livehelp_config` ADD `smtp_password` VARCHAR( 60 ) NOT NULL default ''";
   $results = $conn->query($sql);	
	 $sql = "ALTER TABLE `livehelp_config` ADD `owner_email` VARCHAR( 255 ) NOT NULL default ''";
   $results = $conn->query($sql);	      
 
   $installationtype = "upgrade2142";    
 }

  if( ($installationtype == "upgrade2142") || ($installationtype == "upgrade2143" ) ){

	 $sql = "ALTER TABLE `livehelp_config` ADD `smtp_portnum` int( 10 ) NOT NULL default '25'";
   $results = $conn->query($sql);	    

   $installationtype = "upgrade2144";    
 }

  if( ($installationtype == "upgrade2144") || ($installationtype == "upgrade2145") || ($installationtype == "upgrade2146") || ($installationtype == "upgrade2150")  ){


   $sql = "ALTER TABLE  livehelp_modules_dep ADD  isactive char(1) NOT NULL default 'N' ";
   $results = $conn->query($sql); 	           
 
   $sql = "ALTER TABLE `livehelp_config` ADD `topframeheight` INT( 8 ) NOT NULL default '85' ,ADD `topbackground` VARCHAR( 156 ) NOT NULL  default 'header_images/customersupports.png'";
   $results = $conn->query($sql);

   $sql = "SELECT * FROM livehelp_users WHERE isoperator='Y'";
   $result = $results = $conn->query($sql);
   while ($row = mysqli_fetch_array($result,MYSQLI_ASSOC)) {
      $password = md5($row['password']);
      $user_id = $row['user_id'];
      $sql = "UPDATE livehelp_users SET password='$password' WHERE user_id=$user_id";
      $results = $conn->query($sql);
   }
   
   $installationtype = "upgrade2160";
 }
 
 if( ($installationtype == "upgrade2160")  ){
 
   $sql = "ALTER TABLE `livehelp_config` ADD `usecookies` CHAR( 1 ) NOT NULL DEFAULT 'Y'";
   $results = $conn->query($sql);   
   
   $sql = "ALTER TABLE `livehelp_users` ADD `typing_alert` CHAR( 1 ) NOT NULL DEFAULT 'N'";
   $results = $conn->query($sql);  

   $installationtype = "upgrade2161";
 }
 
 if( ($installationtype == "upgrade2161") || ($installationtype == "upgrade2162") || ($installationtype == "upgrade2163") ){

   $sql = "ALTER TABLE `livehelp_departments` ADD `botbackground` VARCHAR( 255 ) NOT NULL DEFAULT '' AFTER `topbackground`";
   $results = $conn->query($sql);  

   $sql = "ALTER TABLE `livehelp_departments` ADD `midbackground` VARCHAR( 255 ) NOT NULL DEFAULT '' AFTER `topbackground`";
   $results = $conn->query($sql);     

   $sql = "ALTER TABLE `livehelp_departments` ADD `topbackcolor` VARCHAR( 255 ) NOT NULL DEFAULT '' AFTER `midbackground`";
   $results = $conn->query($sql);  
      
   $sql = "ALTER TABLE `livehelp_departments` ADD `midbackcolor` VARCHAR( 255 ) NOT NULL DEFAULT '' AFTER `midbackground`";
   $results = $conn->query($sql);     

   $sql = "ALTER TABLE `livehelp_departments` ADD `botbackcolor` VARCHAR( 255 ) NOT NULL DEFAULT '' AFTER `midbackcolor`";
   $results = $conn->query($sql);    
      
   $sql = "UPDATE `livehelp_users` SET istyping=3";
   $results = $conn->query($sql);  
   
   $sql = "UPDATE `livehelp_departments` SET midbackground='background_images/chat_bubble_bg.png'";
   $results = $conn->query($sql); 

   $sql = "UPDATE `livehelp_departments` SET botbackground='bottom_images/chat_bubble.png'";
   $results = $conn->query($sql); 

   $sql = "UPDATE `livehelp_departments` SET midbackcolor='#FFFFFF'";
   $results = $conn->query($sql); 

   $sql = "UPDATE `livehelp_departments` SET topbackcolor='#FFFFFF'";
   $results = $conn->query($sql);             
   
   $sql = "UPDATE `livehelp_departments` SET botbackcolor='#F0F0F0'";
   $results = $conn->query($sql);        
   
   $installationtype = "upgrade2167";
 }
 
 if( ($installationtype == "upgrade2164") || ($installationtype == "upgrade2165") || ($installationtype == "upgrade2166")  || ($installationtype == "upgrade2167") ){
    
   $sql = "UPDATE `livehelp_users` SET istyping=3";
   $results = $conn->query($sql);  
    	
   $installationtype = "upgrade2168";   
 }
 
 if( ($installationtype == "upgrade2168")  ){
 
    $sql = "ALTER TABLE `livehelp_users` ADD `cellphone` VARCHAR( 255 ) NOT NULL DEFAULT '' ";
    $results = $conn->query($sql); 
    
    $sql = "ALTER TABLE `livehelp_users` ADD `lastcalled` bigint(14) NOT NULL default '0'";
    $results = $conn->query($sql); 
    
    $sql = "ALTER TABLE `livehelp_users` ADD `ismobile` char(1) DEFAULT 'N'  ";
    $results = $conn->query($sql); 
    
    $sql = "ALTER TABLE `livehelp_users` ADD `cell_invite` char(1) DEFAULT 'N'  ";
    $results = $conn->query($sql); 

   $sql = "UPDATE livehelp_config set admin_refresh='auto',everythingelse='YYYY',version='$version'";
   $results = $conn->query($sql);

   $installationtype = "upgrade2169";          
 }

 if( ($installationtype == "upgrade2169")  ){
 
       
   $sql = "ALTER TABLE `livehelp_config` ADD `theme` VARCHAR( 42 ) NOT NULL DEFAULT 'vanilla'";
   $results = $conn->query($sql); 
   
   $sql = "ALTER TABLE `livehelp_config` ADD `showoperator` CHAR( 1 ) NOT NULL DEFAULT 'Y'";
   $results = $conn->query($sql);        
 
   $sql = "ALTER TABLE `livehelp_departments` ADD `theme` VARCHAR( 45 ) NOT NULL DEFAULT 'vanilla'";
   $results = $conn->query($sql); 

   $sql = "ALTER TABLE `livehelp_users` ADD `useimage` CHAR( 1 ) NOT NULL DEFAULT 'N' ";
   $results = $conn->query($sql); 
           

   $installationtype = "upgrade300";    
          
 } 
 
  if( ($installationtype == "upgrade300") || ($installationtype == "upgrade301") || ($installationtype == "upgrade302") || ($installationtype == "upgrade303")|| ($installationtype == "upgrade304")|| ($installationtype == "upgrade305")|| ($installationtype == "upgrade306") ){
  	
    $sql = "UPDATE livehelp_config set showoperator='Y',admin_refresh='auto',everythingelse='YYYY',version='$version'";
    $results = $conn->query($sql);
      
    $sql = "UPDATE `livehelp_departments` SET theme='classic',botbackground='themes/classic/patch.png',midbackground='themes/classic/softyellowomi.png',topbackcolor='#FFFFFF',midbackcolor='#FFFFDD',botbackcolor='#FFFFFF',colorscheme='white'";
    $results = $conn->query($sql); 

    $sql = "UPDATE livehelp_modules_dep Set isactive='N' ";
    $results = $conn->query($sql); 
                         
    $installationtype = "upgrade307";    
     	
  }  
 
   if( ($installationtype == "upgrade307") ){
  	
    $sql = "UPDATE livehelp_config set showoperator='Y',admin_refresh='auto',everythingelse='YYYY',version='$version'";
    $results = $conn->query($sql);

    $sql = "ALTER TABLE `livehelp_config` ADD `chatcolors` text NULL";
    $results = $conn->query($sql);   

    $sql = "ALTER TABLE `livehelp_config` ADD `floatxy`  VARCHAR( 42 ) NOT NULL DEFAULT '200|160'";
    $results = $conn->query($sql);   
   
    $sql = "ALTER TABLE `livehelp_config` ADD `sessiontimeout` INT( 8 ) NOT NULL DEFAULT '60'";
    $results = $conn->query($sql);  
    
    $sql = "ALTER TABLE `livehelp_autoinvite` ADD `user_id` int(10) DEFAULT '0' NOT NULL";
    $results = $conn->query($sql);  
   
    $sql = "ALTER TABLE `livehelp_autoinvite` ADD `socialpane` CHAR( 1 ) DEFAULT 'N' NOT NULL";
    $results = $conn->query($sql);  
   
    $sql = "ALTER TABLE `livehelp_autoinvite` ADD `excludemobile` CHAR( 1 ) DEFAULT 'N' NOT NULL";
    $results = $conn->query($sql);  
   
    $sql = "ALTER TABLE `livehelp_autoinvite` ADD `onlymobile` CHAR( 1 ) DEFAULT 'N' NOT NULL";
    $results = $conn->query($sql);    
 
    $sql = "ALTER TABLE `livehelp_users` ADD `firstdepartment` INT( 11 ) DEFAULT '0' NOT NULL";
    $results = $conn->query($sql);  

    $sql = "ALTER TABLE `livehelp_keywords_daily` ADD `department` INT( 11 ) NOT NULL , ADD INDEX ( `department` )";
    $results = $conn->query($sql);     

    $sql = "ALTER TABLE `livehelp_keywords_monthly` ADD `department` INT( 11 ) NOT NULL , ADD INDEX ( `department` )";
    $results = $conn->query($sql); 

    $sql = "ALTER TABLE `livehelp_referers_daily` ADD `department` INT( 11 ) NOT NULL , ADD INDEX ( `department` )";
    $results = $conn->query($sql);    

    $sql = "ALTER TABLE `livehelp_referers_monthly` ADD `department` INT( 11 ) NOT NULL , ADD INDEX ( `department` )";
    $results = $conn->query($sql);    

    $sql = "ALTER TABLE `livehelp_referers_monthly` ADD `department` INT( 11 ) NOT NULL , ADD INDEX ( `department` )";
    $results = $conn->query($sql);   

    $sql = "ALTER TABLE `livehelp_visits_daily` ADD `department` INT( 11 ) NOT NULL , ADD INDEX ( `department` )";
    $results = $conn->query($sql);          

    $sql = "ALTER TABLE `livehelp_visits_monthly` ADD `department` INT( 11 ) NOT NULL , ADD INDEX ( `department` )";
    $results = $conn->query($sql);         
       
    $sql = "UPDATE `livehelp_autoinvite` SET onlymobile='N',excludemobile='N',socialpane='N',user_id=0";
    $results = $conn->query($sql); 
    
    $sql = "UPDATE `livehelp_config` SET chatcolors='fefdcd,cbcefe,caedbe,cccbba,aecddc,EBBEAA,faacaa,fbddef,cfaaef,aedcbd,bbffff,fedabf;040662,240462,520500,404062,100321,662640,242642,151035,051411,442662,442022,200220;426446,224646,466286,828468,866482,484668,504342,224882,486882,824864,668266,444468'";
    $results = $conn->query($sql);           
      
    $sql = "UPDATE `livehelp_departments` SET theme='classic',botbackground='themes/classic/patch.png',midbackground='themes/classic/softyellowomi.png',topbackcolor='#FFFFFF',midbackcolor='#FFFFDD',botbackcolor='#FFFFFF',colorscheme='white'";
    $results = $conn->query($sql); 

 
    $installationtype = "upgrade308";    
     	
  }  


   if( ($installationtype == "upgrade308") || ($installationtype == "upgrade309") || ($installationtype == "upgrade310")  ){
  	
    $sql = "UPDATE livehelp_config set showoperator='Y',admin_refresh='auto',everythingelse='YYYY',version='$version'";
    $results = $conn->query($sql);
  
    $sql = "DELETE FROM livehelp_operator_history WHERE action='Started Chatting' OR action='Stopped Chatting'";
    $results = $conn->query($sql); 
 
    $sql = "UPDATE `livehelp_config` SET chatcolors='fefdcd,cbcefe,caedbe,cccbba,aecddc,EBBEAA,faacaa,fbddef,cfaaef,aedcbd,bbffff,fedabf;040662,240462,520500,404062,100321,662640,242642,151035,051411,442662,442022,200220;426446,224646,466286,828468,866482,484668,504342,224882,486882,824864,668266,444468'";
    $results = $conn->query($sql);           
 
    $installationtype = "upgrade311";    
     	
  }  
  
  if( ($installationtype == "upgrade311") || ($installationtype == "upgrade310") || ($installationtype == "upgrade311") || ($installationtype == "upgrade312") || ($installationtype == "upgrade313")|| ($installationtype == "upgrade314") ){
      $installationtype = "upgrade315";    
  }
  
  // Upgrade for version 3.1.6 and above: (March 4, 2012)
  if($installationtype == "upgrade315") { 
  	 
     $sql = "ALTER TABLE `livehelp_users` ADD `alertchat` VARCHAR( 45 ) NOT NULL DEFAULT ''";
     $results = $conn->query($sql);
     $sql = "ALTER TABLE `livehelp_users` ADD `alerttyping` VARCHAR( 45 ) NOT NULL DEFAULT ''";
     $results = $conn->query($sql);
     $sql = "ALTER TABLE `livehelp_users` ADD `alertinsite` VARCHAR( 45 ) NOT NULL DEFAULT ''";
     $results = $conn->query($sql);
     $sql = "UPDATE `livehelp_users` SET alertchat='new_chats.wav',alerttyping='click_x.wav',alertinsite='youve_got_visitors.wav' WHERE isoperator='Y' ";
     $results = $conn->query($sql);    
     $results = $conn->query($sql);       
 
    $installationtype = "upgrade316";    
        
  }

  if( ($installationtype == "upgrade316") || ($installationtype == "upgrade317") || ($installationtype == "upgrade318") ){

 
     $sql = "UPDATE `livehelp_departments` SET creditline='Y' ";
     $results = $conn->query($sql);         
  
  
    $installationtype = "upgrade319";    
  }
  
 
  if( ($installationtype == "upgrade319") || ($installationtype == "upgrade3110") || ($installationtype == "upgrade3111") ) { 
 
     $sql = "ALTER TABLE `livehelp_users` ADD INDEX ( `expires` )";
     $results = $conn->query($sql);  
     $sql = "ALTER TABLE `livehelp_users` ADD INDEX ( `sessionid` )";
     $results = $conn->query($sql);  
     $sql = "ALTER TABLE `livehelp_sessions` ADD INDEX ( `expires` )";
     $results = $conn->query($sql);  
            
    $installationtype = "upgrade320";    
  }  
  
 
  if( ($installationtype == "upgrade320") || ($installationtype == "upgrade321") || ($installationtype == "upgrade322") ) { 
 
      $sql = "ALTER TABLE `livehelp_users` ADD `displayname` VARCHAR( 42 ) NOT NULL AFTER `username` ";
     $results = $conn->query($sql);  
     
      $sql = "UPDATE `livehelp_users` SET displayname=username";
     $results = $conn->query($sql);       
 
      $sql = "UPDATE livehelp_config set version='$version'";
     $results = $conn->query($sql);  
    $missingfields = 0;     
    $installationtype = "upgrade323";    
  }
 
 
  if( ($installationtype == "upgrade323") || ($installationtype == "upgrade324") || ($installationtype == "upgrade325") ) { 
 
 
    // New installations of version 3.2.0 , 3.2.1 and 3.2.2 were missing the database field displayname from the livehelp_users table below. 
    $q = "SHOW COLUMNS FROM livehelp_users LIKE 'displayname'";
    $res = $conn->query($q);
    $num_rows = 0;
    if ($res){
      $num_rows = mysqli_num_rows($res);
    }
    if($num_rows==0){
    	  $sql = "ALTER TABLE `livehelp_users` ADD `displayname` VARCHAR( 42 ) NOT NULL AFTER `username` ";
        $results = $conn->query($sql);  
     
        $sql = "UPDATE `livehelp_users` SET displayname=username";
        $results = $conn->query($sql);       
    }
 
    $installationtype = "upgrade326";    
  }   

  // Latest Version CRAFTY SYNTAX Version 3.3.0 :
  if( ($installationtype == "upgrade326") || ($installationtype == "upgrade327") || ($installationtype == "upgrade328") ) { 
  	   
    // New installations of version 3.2.0 , 3.2.1 and 3.2.2 were missing the database field displayname from the livehelp_users table below. 
    $q = "SHOW COLUMNS FROM livehelp_users LIKE 'displayname'";
    $res = $conn->query($q);
    $num_rows = 0;
    if ($res){
      $num_rows = mysqli_num_rows($res);
    }
    if($num_rows==0){
    	  $sql = "ALTER TABLE `livehelp_users` ADD `displayname` VARCHAR( 42 ) NOT NULL AFTER `username` ";
        $results = $conn->query($sql);  
     
        $sql = "UPDATE `livehelp_users` SET displayname=username";
        $results = $conn->query($sql);       
    }
      	   
      $sql = "ALTER TABLE `livehelp_config` ADD `operatorstimeout` INT( 4 ) NOT NULL DEFAULT '4'";
     $results = $conn->query($sql);  

      $sql = "ALTER TABLE `livehelp_config` ADD `operatorssessionout` INT( 8 ) NOT NULL DEFAULT '45'";
     $results = $conn->query($sql);  
    
      $sql = "ALTER TABLE `livehelp_departments` ADD `showtimestamp` CHAR NOT NULL DEFAULT 'N'";
     $results = $conn->query($sql);  
      
      $sql = "ALTER TABLE `livehelp_departments` ADD `website` INT(8) NOT NULL DEFAULT '1'";
     $results = $conn->query($sql);       
     
      $sql = "CREATE TABLE IF NOT EXISTS `livehelp_websites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_name` varchar(45) NOT NULL,
  `site_url` varchar(255) NOT NULL,
  `defaultdepartment` int(8) NOT NULL,  
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
      $results = $conn->query($sql);  

       $sql = "INSERT INTO livehelp_websites (site_name,site_url,defaultdepartment) VALUES ('site_name','site_url','1')";
      $results = $conn->query($sql);
           
     $sql = "UPDATE `livehelp_departments` SET website='1'";
     $results = $conn->query($sql);           
     
      $sql = "SELECT webpath,site_title FROM livehelp_departments ";
     $result = $results = $conn->query($sql);
     $row = mysqli_fetch_array($result,MYSQLI_ASSOC);
     $site_name = $row['site_title'];
     $site_url = $row['webpath'];
     
     $sql = "SELECT webpath,site_title FROM livehelp_config ";
     $result = $results = $conn->query($sql);
     $row = mysqli_fetch_array($result,MYSQLI_ASSOC);
     $site_name = $row['site_title'];
     $site_url = $row['webpath'];
     
      $sql = "UPDATE livehelp_websites SET site_name='$site_name',site_url='$site_url' ";
      $results = $conn->query($sql);
 
      $sql = "ALTER TABLE `livehelp_channels` ADD `website` INT(8) NOT NULL";
      $results = $conn->query($sql);

      $sql = "UPDATE livehelp_users SET visits=1";
      $results = $conn->query($sql);
 
    $installationtype = "upgrade330";    
  }      
  
  if( ($installationtype == "upgrade330") || ($installationtype == "upgrade331") || ($installationtype == "upgrade332") 
   || ($installationtype == "upgrade400") || ($installationtype == "upgrade401") || ($installationtype == "upgrade402") ) { 
    $sql = "CREATE TABLE IF NOT EXISTS `livehelp_websites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_name` varchar(45) NOT NULL,
  `site_url` varchar(255) NOT NULL,
  `defaultdepartment` int(8) NOT NULL,  
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
      $results = $conn->query($sql);  
      
    
     $sql = "ALTER TABLE `livehelp_config` ADD `maxrequests` INT( 8 ) NOT NULL DEFAULT '99999'";
     $results = $conn->query($sql);  
     
     $sql = "ALTER TABLE `livehelp_config` ADD `ignoreagent` text NULL";
     $results = $conn->query($sql); 
          
    $installationtype = "upgrade333";       
    }


//Versions 3.6.2 through 3.7.5 has no database alterations:
if(($installationtype == "upgrade361") || ($installationtype == "upgrade362") ){  
$installationtype == "upgrade362";
 	}  

//Versions 3.3.3 through 3.6.0 need the database alterations that were done in version 3.6.0:
if( ($installationtype == "upgrade333") || ($installationtype == "upgrade334") || ($installationtype == "upgrade335") 
   || ($installationtype == "upgrade336") || ($installationtype == "upgrade337") || ($installationtype == "upgrade338")
   || ($installationtype == "upgrade339") || ($installationtype == "upgrade3310") || ($installationtype == "upgrade3311")
   || ($installationtype == "upgrade340") || ($installationtype == "upgrade341") || ($installationtype == "upgrade342")
   || ($installationtype == "upgrade343") || ($installationtype == "upgrade344") || ($installationtype == "upgrade345")
   || ($installationtype == "upgrade346") || ($installationtype == "upgrade347") || ($installationtype == "upgrade348")
   || ($installationtype == "upgrade349") || ($installationtype == "upgrade350") || ($installationtype == "upgrade351")
   || ($installationtype == "upgrade352") || ($installationtype == "upgrade353") || ($installationtype == "upgrade354")
   || ($installationtype == "upgrade360") || ($installationtype == "upgrade361") ){ 

$sql = "DROP TABLE IF EXISTS livehelp_leads";
 $conn->query($sql); 

  $sql  =  "	
CREATE TABLE IF NOT EXISTS `livehelp_leads` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `email` varchar(90) NOT NULL,
  `phone` varchar(90) NOT NULL,  
  `source` varchar(45) NOT NULL,
  `status` varchar(10) NOT NULL,
  `data` TEXT NOT NULL,
  `firstname` varchar(40) NOT NULL,
  `lastname` varchar(40) NOT NULL,
  `date_entered` int(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `email` (`email`,`source`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		$conn->query($sql);
 		
$sql = "DROP TABLE IF EXISTS livehelp_emails";
 $conn->query($sql); 
 		
 		  $sql  =  "	
CREATE TABLE IF NOT EXISTS `livehelp_emails` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `fromemail` varchar(60) NOT NULL,
  `subject` varchar(60) NOT NULL,
  `bodyof` text NOT NULL,
  `notes` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		$conn->query($sql);
  
 	
 	$sql = "DROP TABLE IF EXISTS livehelp_emailque";
 $conn->query($sql);
  
 	  $sql  =  "	
 	CREATE TABLE IF NOT EXISTS `livehelp_emailque` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `messageid` int(8) NOT NULL,
  `towho` varchar(60) NOT NULL,
  `dateof` int(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `messageid` (`messageid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
 		$conn->query($sql);

     $sql = "ALTER TABLE `livehelp_autoinvite` ADD `offline` INT( 1 ) NOT NULL DEFAULT '0'";
     $conn->query($sql); 
     
$installationtype == "upgrade362";
 	}  
 	 
 	 // Everything past 3.6.2
 		$sql = "ALTER TABLE `livehelp_config` CHANGE `version` `version` VARCHAR( 25 ) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '3.7.5'";
    $results = $conn->query($sql); 
    
// <!-- upon new release: add the updates to the database here.  -->
     $sql = "UPDATE livehelp_config set version='$version',maxrequests='99999'";
     $results = $conn->query($sql);    	   
     $sql = "update livehelp_users set user_alert='A'";
     $results = $conn->query($sql);
        
      
 	  }         
}




if($errors != ""){
  print "<font color=990000 size=+3>THERE WAS A FEW PROBLEMS:</font><ul>";	
  print "$errors";
  print "<a href=javascript:history.go(-1)>CLICK HERE TO TRY AGAIN</a>";
  exit;
}

?>
<center>
<table width=400><tr><td bgcolor=D4DCF2> <b><font size=+3>INSTALLATION IS DONE!!</font></td></tr>
<tr><td bgcolor=F7FAFF>
	<?php  if(!($skipwrite)){ ?>
	You will now need to log into the admin of this Live Help and 
start adding pages. To do this click the link below. <b><font color=990000>write it down</font></b>
<br><br><center>
<b>username:</b><?php echo $UNTRUSTED['username'] ?> <br>
<b>password:</b><?php echo $UNTRUSTED['password1'] ?><br>
 </center>
<?php } ?>
<br>
<h2><b> NOW YOU NEED TO DELETE THE setup.php file </b><br></h2>
<hr>
<a href=http://www.lupopedia.com/updates/?v=<?php echo $version?>&db=<?php echo $UNTRUSTED['dbtype_setup'] ?>><font size=+3>CLICK HERE TO BEGIN REGISTRATION</font></a>
<br><br>
<a href=index.php>Skip REGISTRATION</a><br><br>
<SCRIPT type="text/javascript">
function gothere(){
  // This opens a window to the Live help News page. It sends in the query string the  
  // being installed, type of database used (mysql or text based) and referer. This basic
  // info is just to get an idea of how many successful installations of what versions and 
  // what type of databases for the program are made.    
  url = 'http://www.lupopedia.com/remote/updates.php?v=<?php echo $version; ?>&d=<?php echo $UNTRUSTED['dbtype_setup']; ?>&referer=' + window.location;
  window.open(url, 's872', 'width=590,height=350,menubar=no,scrollbars=1,resizable=1');
}
setTimeout('gothere();',200);
</SCRIPT>
<?php
print "<a href=index.php>CLICK HERE to get started.. </a></td></tr></table>";
exit;
}
?>
<SCRIPT type="text/javascript">

function openwindow(theURL,winName,features) {//v1.0 
win2 = window.open(theURL,winName,features); 
window.win2.focus(); 
}
 
</script>

<h2>CRAFTY SYNTAX Live Help verison <?php echo $version?> Installation
<?php
$test_dir = getcwd();
?>
</h2>
problems on this page?!? <a href=http://www.lupopedia.com/help/ TARGET=_blank>CLICK HERE TO GO TO SUPPORT PAGE</a>
<hr>
<?php
if ($errors != ""){
  print "<table width=600><tr><td><font color=990000>ERRORS: $errors</font></td></tr></table>";	
}

// Check to see if we can write to the config file.
if($UNTRUSTED['manualinstall'] != "YES"){
$fp = fopen ("config.php", "r+");
} else {
$fp = True;	
}

if(!$fp){
?>
<table width=500 bgcolor=F7FAFF><tr><td>
<font color=990000 size=+2><b>Can not open <font color=000099>config.php</font> file for writing:</b></font><br>


<hr>
<font color=007700><b>HOW TO FIX THIS:</b></font><br><br>
In order to configure the Live Help using this web wizard,
 the web server needs to be able to read and write to the
 file named <b><i>config.php</i></b>. if you can not change
 the permissions of this file then there is a manual change 
 option listed at the bottom of this page... 
 if you are planning on 
 using a text based database you will also need to change the
 permissions of the directory <b>txt-database</b>. Directions on doing  this follows:
<br>
Installing and configuring CSLH is done via a set of web pages.
To enable these web pages you need to log onto your web server using
telnet or (preferably) ssh, go to the CSLH directory and at the
prompt (which usually ends in '%' or '$') type:
<br><br>
chmod 777 txt-database <font color=990000><i>(if using a text based database)</i></font><br>
chmod 777 config.php<br>
<br><br>
After installation you can change the permissions of config.php to chmod 755.
<br><br>
if you can not ssh or telent into your website you can to the same task by
FTP: 
<br><br>	
Using WS_FTP this would be right hand clicking on the 
file config.php , selecting chmod, and then giving all
permissions to that file/directory. 
<br>
<img src=directions.gif>
<br>
<hr>
<br>
<h2><b>Manual config change option:</b></h2>
if you do not have access to, or can not change the permissions of config.php you 
also have the Option to update config.php yourself. 
<a href=setup.php?manualinstall=YES>CLICK HERE TO RUN INSTALLAION BY MANUALLY CHANGING config.php</a><br>
<br>
</td></tr></table><br>
<a href=setup.php>AFTER YOU HAVE CHANGED THE PERMISSIONS OF THE 
FILES HOLD DOWN THE shift KEY and PRESS REFRESH or RELOAD</a>
<br>
<br><br>
<table bgcolor=FFFFFF><tr><td>
<h3>if you can not change the permissions of the files here are Manual Installation Directions:</h3>
<hr>
if you do not have access to, or can not change the permissions of config.php you 
also have the Option to update config.php yourself after the database has been created. 
<a href=setup.php?manualinstall=YES>CLICK HERE TO RUN INSTALLAION BY MANUALLY CHANGING config.php</a><br>

</td></tr></table>

</td></tr></table>
<?php
exit;
}


?>
<FORM action=setup.php method=post name=erics>
<input type=hidden name=manualinstall value="<?php echo $UNTRUSTED['manualinstall']; ?>">
<table width=600 bgcolor=F7FAFF>
<?php

if (empty($UNTRUSTED['site_title'])){
  $UNTRUSTED['site_title'] = "My Online Live Help";
}

if(empty($UNTRUSTED['speaklanguage']))
  $UNTRUSTED['speaklanguage'] = "English";

if(empty($UNTRUSTED['installationtype']))
  $UNTRUSTED['installationtype'] = "newinstall";

if(empty($UNTRUSTED['username']))
  $UNTRUSTED['username'] = "";
  
if(empty($UNTRUSTED['password1']))
  $UNTRUSTED['password1'] = "";

if(empty($UNTRUSTED['password2']))
  $UNTRUSTED['password2'] = "";

if(empty($UNTRUSTED['email']))
  $UNTRUSTED['email'] = "";
  
if(empty($UNTRUSTED['rootpath']))
  $UNTRUSTED['rootpath'] = "";        

if(empty($UNTRUSTED['opening']))
  $UNTRUSTED['opening'] = "";   

if(empty($UNTRUSTED['dbtype_setup']))
  $UNTRUSTED['dbtype_setup'] = "";   

if(empty($UNTRUSTED['server_setup']))
  $UNTRUSTED['server_setup'] = "localhost"; 

if(empty($UNTRUSTED['database_setup']))
  $UNTRUSTED['database_setup'] = ""; 

if(empty($UNTRUSTED['datausername_setup']))
  $UNTRUSTED['datausername_setup'] = ""; 

if(empty($UNTRUSTED['mypassword_setup']))
  $UNTRUSTED['mypassword_setup'] = ""; 

if(empty($UNTRUSTED['txtpath']))
  $UNTRUSTED['txtpath'] = ""; 

if(empty($UNTRUSTED['s_homepage']))
  $UNTRUSTED['s_homepage'] = ""; 

if (empty($UNTRUSTED['homepage'])){ 
	$dir = dirname((!empty($_SERVER['PHP_SELF'])) ? $_SERVER['PHP_SELF'] : $_ENV['PHP_SELF']);
  $host = ( !empty($_SERVER['HTTP_HOST']) ) ? $_SERVER['HTTP_HOST'] : ( ( !empty($_ENV['HTTP_HOST']) ) ? $_ENV['HTTP_HOST'] : $HTTP_HOST );
  $UNTRUSTED['homepage']  = "http://" . $host . $dir;
}
  
if(empty($UNTRUSTED['openingmessage']))
  $UNTRUSTED['openingmessage'] = ""; 
        
 
 
?>
<tr><td bgcolor=DDDDDD colspan=2><b>LANGUAGE:</b></td></tr>
<tr><td bgcolor=EEEECC colspan=2>
All of the text for CSLH that is shown on the
users side can be in :<br>
</td></tr>
<tr><td>Language:</td>
<td><select name=speaklanguage>
 
<?php
// get list of installed langages..
$dir = "lang" . C_DIR;
if($handle=opendir($dir)){
	while (false !== ($file = readdir($handle))) {
	if ( (preg_match("/lang/",$file)) && ($file != "lang-.php"))
		{
		if (is_file("$dir/$file"))
			{
			$language = str_replace("lang-","",$file);
			$language = str_replace(".php","",$language);
			?><option value=<?php echo $language ?> <?php if ($UNTRUSTED['speaklanguage'] == $language){ print " SELECTED "; } ?> ><?php echo $language ?> </option><?php
			}
		}
	}
// no list guess...
} else {
      $languages = array("Dutch","English","English_uk","French","German","Italian","Portuguese_Brazilian","Spanish","Swedish");
			for($i=0;$i<count($languages); $i++){
  			$language = $languages[$i];
  			?><option value=<?php echo $language ?> <?php if ($UNTRUSTED['speaklanguage'] == $language){ print " SELECTED "; } ?> ><?php echo $language ?> </option><?php		
  		}	
}	
?>
 
</select>
</td></tr>

<tr><td bgcolor=DDDDDD colspan=2><b>INSTALLATION OPTION:</b></td></tr>
<tr><td bgcolor=EEEECC colspan=2>
You can upgrade to 
the newest version of the Live Help and not lose any of your data...<br>
</td></tr>
<tr><td>Installation:</td>
<td><input type=hidden name=freshinstall value=1><select name=installationtype>
<option value=newinstall>NEW INSTALLATION</option>
<!-- upon new release: add new upgrade line below -->
<option value=upgrade505 <?php if ($installationtype == "upgrade505"){ print " SELECTED "; } ?> >UPGRADE from version 5.0.5 </option>
<option value=upgrade504 <?php if ($installationtype == "upgrade504"){ print " SELECTED "; } ?> >UPGRADE from version 5.0.4 </option>
<option value=upgrade503 <?php if ($installationtype == "upgrade503"){ print " SELECTED "; } ?> >UPGRADE from version 5.0.3 </option>
<option value=upgrade502 <?php if ($installationtype == "upgrade502"){ print " SELECTED "; } ?> >UPGRADE from version 5.0.2 </option>
<option value=upgrade501 <?php if ($installationtype == "upgrade501"){ print " SELECTED "; } ?> >UPGRADE from version 5.0.1 </option>
<option value=upgrade500 <?php if ($installationtype == "upgrade500"){ print " SELECTED "; } ?> >UPGRADE from version 5.0.0 </option>

<option value=upgrade406 <?php if ($installationtype == "upgrade406"){ print " SELECTED "; } ?> >UPGRADE from version 4.0.6 </option>
<option value=upgrade405 <?php if ($installationtype == "upgrade405"){ print " SELECTED "; } ?> >UPGRADE from version 4.0.5 </option>
<option value=upgrade404 <?php if ($installationtype == "upgrade404"){ print " SELECTED "; } ?> >UPGRADE from version 4.0.4 </option>
<option value=upgrade403 <?php if ($installationtype == "upgrade403"){ print " SELECTED "; } ?> >UPGRADE from version 4.0.3 </option>
<option value=upgrade402 <?php if ($installationtype == "upgrade402"){ print " SELECTED "; } ?> >UPGRADE from version 4.0.2 </option>
<option value=upgrade401 <?php if ($installationtype == "upgrade401"){ print " SELECTED "; } ?> >UPGRADE from version 4.0.1 </option>
<option value=upgrade400 <?php if ($installationtype == "upgrade400"){ print " SELECTED "; } ?> >UPGRADE from version 4.0.0 </option>

<option value=upgrade362 <?php if ($installationtype == "upgrade362"){ print " SELECTED "; } ?> >UPGRADE from version 3.6.2 </option>  
<option value=upgrade361 <?php if ($installationtype == "upgrade361"){ print " SELECTED "; } ?> >UPGRADE from version 3.6.1 </option>
<option value=upgrade360 <?php if ($installationtype == "upgrade360"){ print " SELECTED "; } ?> >UPGRADE from version 3.6.0 </option>
<option value=upgrade354 <?php if ($installationtype == "upgrade354"){ print " SELECTED "; } ?> >UPGRADE from version 3.5.4 </option>
<option value=upgrade353 <?php if ($installationtype == "upgrade353"){ print " SELECTED "; } ?> >UPGRADE from version 3.5.3 </option>
<option value=upgrade352 <?php if ($installationtype == "upgrade352"){ print " SELECTED "; } ?> >UPGRADE from version 3.5.2 </option>
<option value=upgrade351 <?php if ($installationtype == "upgrade351"){ print " SELECTED "; } ?> >UPGRADE from version 3.5.1 </option>
<option value=upgrade350 <?php if ($installationtype == "upgrade350"){ print " SELECTED "; } ?> >UPGRADE from version 3.5.0 </option>
<option value=upgrade349 <?php if ($installationtype == "upgrade349"){ print " SELECTED "; } ?> >UPGRADE from version 3.4.9 </option>
         
<option value=upgrade348 <?php if ($installationtype == "upgrade348"){ print " SELECTED "; } ?> >UPGRADE from version 3.4.8 </option>
<option value=upgrade347 <?php if ($installationtype == "upgrade347"){ print " SELECTED "; } ?> >UPGRADE from version 3.4.7 </option>
<option value=upgrade346 <?php if ($installationtype == "upgrade346"){ print " SELECTED "; } ?> >UPGRADE from version 3.4.6 </option>
<option value=upgrade345 <?php if ($installationtype == "upgrade345"){ print " SELECTED "; } ?> >UPGRADE from version 3.4.5 </option>
<option value=upgrade344 <?php if ($installationtype == "upgrade344"){ print " SELECTED "; } ?> >UPGRADE from version 3.4.4 </option>
<option value=upgrade343 <?php if ($installationtype == "upgrade343"){ print " SELECTED "; } ?> >UPGRADE from version 3.4.3 </option>
<option value=upgrade342 <?php if ($installationtype == "upgrade342"){ print " SELECTED "; } ?> >UPGRADE from version 3.4.2 </option>
<option value=upgrade341 <?php if ($installationtype == "upgrade341"){ print " SELECTED "; } ?> >UPGRADE from version 3.4.1 </option>
<option value=upgrade340 <?php if ($installationtype == "upgrade340"){ print " SELECTED "; } ?> >UPGRADE from version 3.4.0 </option>
<option value=upgrade3311 <?php if ($installationtype == "upgrade3311"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.11 </option>
<option value=upgrade3310 <?php if ($installationtype == "upgrade3310"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.10 </option>
<option value=upgrade339 <?php if ($installationtype == "upgrade339"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.9 </option>
<option value=upgrade338 <?php if ($installationtype == "upgrade338"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.8 </option>
<option value=upgrade337 <?php if ($installationtype == "upgrade337"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.7 </option>
<option value=upgrade336 <?php if ($installationtype == "upgrade336"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.6 </option>
<option value=upgrade335 <?php if ($installationtype == "upgrade335"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.5 </option>
<option value=upgrade334 <?php if ($installationtype == "upgrade334"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.4 </option>
<option value=upgrade333 <?php if ($installationtype == "upgrade333"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.3 </option>
<option value=upgrade332 <?php if ($installationtype == "upgrade332"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.2 </option>
<option value=upgrade331 <?php if ($installationtype == "upgrade331"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.1 </option>
<option value=upgrade330 <?php if ($installationtype == "upgrade330"){ print " SELECTED "; } ?> >UPGRADE from version 3.3.0 </option>
<option value=upgrade328 <?php if ($installationtype == "upgrade328"){ print " SELECTED "; } ?> >UPGRADE from version 3.2.8 </option>
<option value=upgrade327 <?php if ($installationtype == "upgrade327"){ print " SELECTED "; } ?> >UPGRADE from version 3.2.7 </option>
<option value=upgrade326 <?php if ($installationtype == "upgrade326"){ print " SELECTED "; } ?> >UPGRADE from version 3.2.6 </option>
<option value=upgrade325 <?php if ($installationtype == "upgrade325"){ print " SELECTED "; } ?> >UPGRADE from version 3.2.5 </option>
<option value=upgrade324 <?php if ($installationtype == "upgrade324"){ print " SELECTED "; } ?> >UPGRADE from version 3.2.4 </option>
<option value=upgrade323 <?php if ($installationtype == "upgrade323"){ print " SELECTED "; } ?> >UPGRADE from version 3.2.3 </option>
<option value=upgrade322 <?php if ($installationtype == "upgrade322"){ print " SELECTED "; } ?> >UPGRADE from version 3.2.2 </option>
<option value=upgrade321 <?php if ($installationtype == "upgrade321"){ print " SELECTED "; } ?> >UPGRADE from version 3.2.1 </option>
<option value=upgrade320 <?php if ($installationtype == "upgrade320"){ print " SELECTED "; } ?> >UPGRADE from version 3.2.0 </option>
<option value=upgrade3111 <?php if ($installationtype == "upgrade3111"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.11 </option>
<option value=upgrade3110 <?php if ($installationtype == "upgrade3110"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.10 </option>
<option value=upgrade319 <?php if ($installationtype == "upgrade319"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.9 </option>
<option value=upgrade318 <?php if ($installationtype == "upgrade318"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.8 </option>
<option value=upgrade317 <?php if ($installationtype == "upgrade317"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.7 </option>
<option value=upgrade316 <?php if ($installationtype == "upgrade316"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.6 </option>
<option value=upgrade315 <?php if ($installationtype == "upgrade315"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.5 </option>
<option value=upgrade314 <?php if ($installationtype == "upgrade314"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.4 </option>
<option value=upgrade313 <?php if ($installationtype == "upgrade313"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.3 </option>
<option value=upgrade312 <?php if ($installationtype == "upgrade312"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.2 </option>
<option value=upgrade311 <?php if ($installationtype == "upgrade311"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.1 </option>
<option value=upgrade310 <?php if ($installationtype == "upgrade310"){ print " SELECTED "; } ?> >UPGRADE from version 3.1.0 </option>
<option value=upgrade309 <?php if ($installationtype == "upgrade309"){ print " SELECTED "; } ?> >UPGRADE from version 3.0.9 </option>
<option value=upgrade308 <?php if ($installationtype == "upgrade308"){ print " SELECTED "; } ?> >UPGRADE from version 3.0.8 </option>
<option value=upgrade307 <?php if ($installationtype == "upgrade307"){ print " SELECTED "; } ?> >UPGRADE from version 3.0.7 </option>
<option value=upgrade306 <?php if ($installationtype == "upgrade306"){ print " SELECTED "; } ?> >UPGRADE from version 3.0.6 </option>
<option value=upgrade305 <?php if ($installationtype == "upgrade305"){ print " SELECTED "; } ?> >UPGRADE from version 3.0.5 </option>
<option value=upgrade304 <?php if ($installationtype == "upgrade304"){ print " SELECTED "; } ?> >UPGRADE from version 3.0.4 </option>
<option value=upgrade303 <?php if ($installationtype == "upgrade303"){ print " SELECTED "; } ?> >UPGRADE from version 3.0.3 </option>
<option value=upgrade302 <?php if ($installationtype == "upgrade302"){ print " SELECTED "; } ?> >UPGRADE from version 3.0.2 </option>
<option value=upgrade301 <?php if ($installationtype == "upgrade301"){ print " SELECTED "; } ?> >UPGRADE from version 3.0.1 </option>
<option value=upgrade300 <?php if ($installationtype == "upgrade300"){ print " SELECTED "; } ?> >UPGRADE from version 3.0.0 </option>
<option value=upgrade2169 <?php if ($installationtype == "upgrade2169"){ print " SELECTED "; } ?> >UPGRADE from version 2.16.9 </option>
<option value=upgrade2168 <?php if ($installationtype == "upgrade2168"){ print " SELECTED "; } ?> >UPGRADE from version 2.16.8 </option>
<option value=upgrade2167 <?php if ($installationtype == "upgrade2167"){ print " SELECTED "; } ?> >UPGRADE from version 2.16.7 </option>
<option value=upgrade2166 <?php if ($installationtype == "upgrade2166"){ print " SELECTED "; } ?> >UPGRADE from version 2.16.6 </option>
<option value=upgrade2165 <?php if ($installationtype == "upgrade2165"){ print " SELECTED "; } ?> >UPGRADE from version 2.16.5 </option>
<option value=upgrade2164 <?php if ($installationtype == "upgrade2164"){ print " SELECTED "; } ?> >UPGRADE from version 2.16.4 </option>
<option value=upgrade2163 <?php if ($installationtype == "upgrade2163"){ print " SELECTED "; } ?> >UPGRADE from version 2.16.3 </option>
<option value=upgrade2162 <?php if ($installationtype == "upgrade2162"){ print " SELECTED "; } ?> >UPGRADE from version 2.16.2 </option>
<option value=upgrade2161 <?php if ($installationtype == "upgrade2161"){ print " SELECTED "; } ?> >UPGRADE from version 2.16.1 </option>
<option value=upgrade2160 <?php if ($installationtype == "upgrade2160"){ print " SELECTED "; } ?> >UPGRADE from version 2.16.0 </option>
<option value=upgrade2150 <?php if ($installationtype == "upgrade2150"){ print " SELECTED "; } ?> >UPGRADE from version 2.15.0 </option>
<option value=upgrade2146 <?php if ($installationtype == "upgrade2146"){ print " SELECTED "; } ?> >UPGRADE from version 2.14.6 </option>
<option value=upgrade2145 <?php if ($installationtype == "upgrade2145"){ print " SELECTED "; } ?> >UPGRADE from version 2.14.5 </option>
<option value=upgrade2144 <?php if ($installationtype == "upgrade2144"){ print " SELECTED "; } ?> >UPGRADE from version 2.14.4 </option>
<option value=upgrade2143 <?php if ($installationtype == "upgrade2143"){ print " SELECTED "; } ?> >UPGRADE from version 2.14.3 </option>
<option value=upgrade2142 <?php if ($installationtype == "upgrade2142"){ print " SELECTED "; } ?> >UPGRADE from version 2.14.2 </option>
<option value=upgrade2141 <?php if ($installationtype == "upgrade2141"){ print " SELECTED "; } ?> >UPGRADE from version 2.14.1 </option>
<option value=upgrade2140 <?php if ($installationtype == "upgrade2140"){ print " SELECTED "; } ?> >UPGRADE from version 2.14.0 </option>
<option value=upgrade2131 <?php if ($installationtype == "upgrade2131"){ print " SELECTED "; } ?> >UPGRADE from version 2.13.1 </option>
<option value=upgrade2130 <?php if ($installationtype == "upgrade2130"){ print " SELECTED "; } ?> >UPGRADE from version 2.13.0 </option>
<option value=upgrade2129 <?php if ($installationtype == "upgrade2129"){ print " SELECTED "; } ?> >UPGRADE from version 2.12.9 </option>
<option value=upgrade2128 <?php if ($installationtype == "upgrade2128"){ print " SELECTED "; } ?> >UPGRADE from version 2.12.8 </option>
<option value=upgrade2127 <?php if ($installationtype == "upgrade2127"){ print " SELECTED "; } ?> >UPGRADE from version 2.12.7 </option>
<option value=upgrade2126 <?php if ($installationtype == "upgrade2126"){ print " SELECTED "; } ?> >UPGRADE from version 2.12.6 </option>
<option value=upgrade2125 <?php if ($installationtype == "upgrade2125"){ print " SELECTED "; } ?> >UPGRADE from version 2.12.5 </option>
<option value=upgrade2124 <?php if ($installationtype == "upgrade2124"){ print " SELECTED "; } ?> >UPGRADE from version 2.12.4 </option>
<option value=upgrade2123 <?php if ($installationtype == "upgrade2123"){ print " SELECTED "; } ?> >UPGRADE from version 2.12.3 </option>
<option value=upgrade2122 <?php if ($installationtype == "upgrade2122"){ print " SELECTED "; } ?> >UPGRADE from version 2.12.2 </option>
<option value=upgrade2121 <?php if ($installationtype == "upgrade2121"){ print " SELECTED "; } ?> >UPGRADE from version 2.12.1 </option>
<option value=upgrade2120 <?php if ($installationtype == "upgrade2120"){ print " SELECTED "; } ?> >UPGRADE from version 2.12.0 </option>
<option value=upgrade2117 <?php if ($installationtype == "upgrade2117"){ print " SELECTED "; } ?> >UPGRADE from version 2.11.7 </option>
<option value=upgrade2116 <?php if ($installationtype == "upgrade2116"){ print " SELECTED "; } ?> >UPGRADE from version 2.11.6 </option>
<option value=upgrade2115 <?php if ($installationtype == "upgrade2115"){ print " SELECTED "; } ?> >UPGRADE from version 2.11.5 </option>
<option value=upgrade2114 <?php if ($installationtype == "upgrade2114"){ print " SELECTED "; } ?> >UPGRADE from version 2.11.4 </option>
<option value=upgrade2113 <?php if ($installationtype == "upgrade2113"){ print " SELECTED "; } ?> >UPGRADE from version 2.11.3 </option>
<option value=upgrade2112 <?php if ($installationtype == "upgrade2112"){ print " SELECTED "; } ?> >UPGRADE from version 2.11.2 </option>
<option value=upgrade2111 <?php if ($installationtype == "upgrade2111"){ print " SELECTED "; } ?> >UPGRADE from version 2.11.1 </option>
<option value=upgrade2110 <?php if ($installationtype == "upgrade2110"){ print " SELECTED "; } ?> >UPGRADE from version 2.11.0 </option>
<option value=upgrade2105 <?php if ($installationtype == "upgrade2105"){ print " SELECTED "; } ?> >UPGRADE from version 2.10.5 </option>
<option value=upgrade2104 <?php if ($installationtype == "upgrade2104"){ print " SELECTED "; } ?> >UPGRADE from version 2.10.4 </option>
<option value=upgrade2103 <?php if ($installationtype == "upgrade2103"){ print " SELECTED "; } ?> >UPGRADE from version 2.10.3 </option>
<option value=upgrade2102 <?php if ($installationtype == "upgrade2102"){ print " SELECTED "; } ?> >UPGRADE from version 2.10.2 </option>
<option value=upgrade2101 <?php if ($installationtype == "upgrade2101"){ print " SELECTED "; } ?> >UPGRADE from version 2.10.1 </option>
<option value=upgrade2100 <?php if ($installationtype == "upgrade2100"){ print " SELECTED "; } ?> >UPGRADE from version 2.10.0 </option>
<option value=upgrade299 <?php if ($installationtype == "upgrade299"){ print " SELECTED "; } ?> >UPGRADE from version 2.9.9 </option>
<option value=upgrade298 <?php if ($installationtype == "upgrade298"){ print " SELECTED "; } ?> >UPGRADE from version 2.9.8 </option>
<option value=upgrade297 <?php if ($installationtype == "upgrade297"){ print " SELECTED "; } ?> >UPGRADE from version 2.9.7 </option>
<option value=upgrade296 <?php if ($installationtype == "upgrade296"){ print " SELECTED "; } ?> >UPGRADE from version 2.9.6 </option>
<option value=upgrade295 <?php if ($installationtype == "upgrade295"){ print " SELECTED "; } ?> >UPGRADE from version 2.9.5 </option>
<option value=upgrade294 <?php if ($installationtype == "upgrade294"){ print " SELECTED "; } ?> >UPGRADE from version 2.9.4 </option>
<option value=upgrade293 <?php if ($installationtype == "upgrade293"){ print " SELECTED "; } ?> >UPGRADE from version 2.9.3 </option>
<option value=upgrade292 <?php if ($installationtype == "upgrade292"){ print " SELECTED "; } ?> >UPGRADE from version 2.9.2 </option>
<option value=upgrade291 <?php if ($installationtype == "upgrade291"){ print " SELECTED "; } ?> >UPGRADE from version 2.9.1 </option>
<option value=upgrade290 <?php if ($installationtype == "upgrade290"){ print " SELECTED "; } ?> >UPGRADE from version 2.9.0 </option>
<option value=upgrade284 <?php if ($installationtype == "upgrade284"){ print " SELECTED "; } ?> >UPGRADE from version 2.8.4 </option>
<option value=upgrade283 <?php if ($installationtype == "upgrade283"){ print " SELECTED "; } ?> >UPGRADE from version 2.8.3 </option>
<option value=upgrade282 <?php if ($installationtype == "upgrade282"){ print " SELECTED "; } ?> >UPGRADE from version 2.8.2 </option>
<option value=upgrade281 <?php if ($installationtype == "upgrade281"){ print " SELECTED "; } ?> >UPGRADE from version 2.8.1 </option>
<option value=upgrade280 <?php if ($installationtype == "upgrade280"){ print " SELECTED "; } ?> >UPGRADE from version 2.8.0 </option>
<option value=upgrade274 <?php if ($installationtype == "upgrade274"){ print " SELECTED "; } ?> >UPGRADE from version 2.7.4 </option>
<option value=upgrade273 <?php if ($installationtype == "upgrade273"){ print " SELECTED "; } ?> >UPGRADE from version 2.7.3 </option>
<option value=upgrade272 <?php if ($installationtype == "upgrade272"){ print " SELECTED "; } ?> >UPGRADE from version 2.7.2 </option>
<option value=upgrade271 <?php if ($installationtype == "upgrade271"){ print " SELECTED "; } ?> >UPGRADE from version 2.7.1 </option>
<option value=upgrade27 <?php if ($installationtype == "upgrade27"){ print " SELECTED "; } ?> >UPGRADE from version 2.7 </option>
<option value=upgrade26 <?php if ($installationtype == "upgrade26"){ print " SELECTED "; } ?> >UPGRADE from version 2.6 </option>
<option value=upgrade25 <?php if ($installationtype == "upgrade25"){ print " SELECTED "; } ?> >UPGRADE from version 2.5 </option>
<option value=upgrade24 <?php if ($installationtype == "upgrade24"){ print " SELECTED "; } ?> >UPGRADE from version 2.4 </option>
<option value=upgrade22 <?php if ($installationtype == "upgrade22"){ print " SELECTED "; } ?> >UPGRADE from version 2.2 or 2.3 </option>
<option value=upgrade <?php if ($installationtype == "upgrade"){ print " SELECTED "; } ?> >UPGRADE from Before version 2.2 </option>
</select>
</td></tr>
<tr><td bgcolor=DDDDDD colspan=2><b>Title of your Live Help:</b></td></tr>
<tr><td bgcolor=EEEECC colspan=2>This is the title of your Live Help.</td></tr>
<tr><td>Title of your Live Help:</td><td><input type=text name=site_title size=40 value="<?php echo $UNTRUSTED['site_title']; ?>"></td></tr> 
<tr><td bgcolor=DDDDDD colspan=2><b>Web path to Live Help:</b></td></tr>
<tr><td bgcolor=EEEECC colspan=2>This is the url to the Live Help on your server. It will be used 
to access the online help for your site..</td></tr>
<tr><td>Live Help HTTP path:</td><td><input type=text name=homepage size=40 value="<?php echo $UNTRUSTED['homepage']; ?>"></td></tr>
<tr><td>Live Help HTTPS path:</td><td><input type=text name=s_homepage size=40 value="<?php echo $UNTRUSTED['s_homepage']; ?>"></td></tr>
<tr><td bgcolor=DDDDDD colspan=2><b>Administration user/Password:</b></td></tr>
<tr><td bgcolor=EEEECC colspan=2>
Although you can create multiple Operators for the Live Help, there is
a main administrator that can create users, edit,
add, delete everything. Create that account here.</td></tr>
<tr><td>username:</td><td><input type=text name=username size=10 value="<?php echo $UNTRUSTED['username']; ?>"></td></tr>
<tr><td>password:</td><td><input type=password name=password1 size=10 value="<?php echo $UNTRUSTED['password1']; ?>"></td></tr>
<tr><td>password (again):</td><td><input type=password name=password2 size=10 value="<?php echo $UNTRUSTED['password2']; ?>"></td></tr>
<tr><td bgcolor=DDDDDD colspan=2><b>Administration e-mail:</b></td></tr>
<tr><td bgcolor=EEEECC colspan=2>This is the e-mail address for the administrator of this Live Help program (used for lost password ) .</td></tr>
<tr><td>email:</td><td><input type=text name=email size=30 value="<?php echo $UNTRUSTED['email']; ?>"></td></tr>

<tr><td bgcolor=DDDDDD colspan=2><b>Full Path to Live Help:</b></td></tr>
<tr><td bgcolor=EEEECC colspan=2>
This is the Full Path to Live Help. 
This file path should be like /www/username/public_html/livehelp NOT http://yoursite.com/livehelp/ </td></tr>
<tr><td>Full Path to Live Help:</td><td><input type=text name=rootpath size=55 value="<?php if(!(empty($UNTRUSTED['rootpath']))){ print $UNTRUSTED['rootpath']; } else { print getcwd(); } ?>"></td></tr>
<tr><td bgcolor=DDDDDD colspan=2><b>Opening message:</b></td></tr>
<tr><td bgcolor=EEEECC colspan=2>
When users first open up the Live Help they are directed to a
page to enter in their name so that Operators can identify them
easy. This is the text shown on that opening page.</td></tr>
<tr><td colspan=2>
<b>Opening Message:</b><br>
<textarea cols=45 rows=4 name=opening>
<?php
if(empty($UNTRUSTED['openingmessage'])){
print "Welcome to our Live Help. Please enter your name in the input box below to begin.";
} else {
print $UNTRUSTED['openingmessage'];
}
?>
</textarea>
</td></tr>
<tr><td bgcolor=DDDDDD colspan=2><b>Type of Database:</b></td></tr>
<tr><td bgcolor=EEEECC colspan=2>
This is the type of database that you are using. 
If you are having trouble with your database settings you can 
 
 <br>
It is HIGHLY recommended that you use 
MySQL and NOT use txt-db-api. Please use Mysql if you have a
mysql database. Use txt-db-api only as a LAST resort as it is VERY slower then mysql
and also can corrupt easy..  
<br>
<?php 
 $default_db = $test_dir . "/txt-database"; 
?>
<br>
To a location OUTSIDE the web accessible htdocs folder of your website and place
the full path to the txt-database folder below:
 <br>
This version of CRAFTY SYNTAX requires a Mysql Database.  
<br>
</td></tr>

<tr><td>Database:</td><td><select name=dbtype_setup>
<option value=mysql <?php if ($UNTRUSTED['dbtype_setup'] == "mysql"){ print " SELECTED "; } ?> >MySQLi </option>
<!--<option value=txt-db-api <?php if ($UNTRUSTED['dbtype_setup'] == "txt-db-api"){ print " SELECTED "; } ?> >txt-db-api (simple Flat text files)</option>-->
</select></td></tr>
<tr><td colspan=2><ul>
<table bgcolor=D4DCF2>
<tr><td colspan=2>If <b>MySQLi</b> is selected above:</td></tr>
<?php if($UNTRUSTED['server_setup'] == ""){ $server_setup = "localhost"; } ?>
<tr><td>SQL server:</td><td><input type=text name=server_setup size=20 value="<?php echo $UNTRUSTED['server_setup']; ?>" ></td></tr>
<tr><td>SQL database:</td><td><input type=text name=database_setup size=20 value="<?php echo $UNTRUSTED['database_setup']; ?>"></td></tr>
<tr><td>SQL user:</td><td><input type=text name=datausername_setup size=20 value="<?php echo $UNTRUSTED['datausername_setup']; ?>"></td></tr>
<tr><td>SQL password:</td><td><input type=password name=mypassword_setup size=20 value="<?php echo $UNTRUSTED['mypassword_setup']; ?>"></td></tr>
</table><br>
 
<table bgcolor=D4DCF2>
<tr><td colspan=2>If <b>txt-db-api (simple Flat text files)</b> is selected above you need to provide a 
full path to the directory where the txt files will be stored. This directory must be writable 
by the web and should not be in a web accessible directory. NOTE that it is <font color=990000><b><u>HIGHLY</u></b></font> suggested that
the txt-database directory be located OUTSIDE the public html files. See <a href=txt-database/README.txt target=_blank>Directions</a></td></tr>
<tr><td>txt path:</td><td><input type=text name=txtpath size=55 value="<?php if($UNTRUSTED['txtpath'] != ""){ print $UNTRUSTED['txtpath']; } else print $default_db;  ?>" ></td></tr> 
</table>
 

</td></tr>
</table></td></tr>
</table>

<input type=SUBMIT name=action value=INSTALL>
</form>

